/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.continuum.configuration.BuildAgentConfigurationException;
import org.apache.continuum.model.release.ContinuumReleaseResult;
import org.apache.continuum.release.distributed.DistributedReleaseUtil;
import org.apache.continuum.release.distributed.manager.DistributedReleaseManager;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.ReleaseListenerSummary;
import org.apache.maven.shared.release.ReleaseResult;

public class ReleaseInProgressAction
extends ContinuumActionSupport {
    private int projectId;
    private String releaseId;
    private String releaseGoal;
    private ContinuumReleaseManagerListener listener;
    private ReleaseResult result;
    private String projectGroupName = "";
    private ReleaseListenerSummary listenerSummary;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute() throws Exception {
        ReleaseResult result;
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        String status = "";
        this.listenerSummary = new ReleaseListenerSummary();
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            ReleaseResult result2;
            Map map;
            DistributedReleaseManager releaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                map = releaseManager.getListener(this.releaseId);
            }
            catch (BuildAgentConfigurationException e) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(e.getMessage());
                this.addActionError(this.getText("releaseInProgress.error", args));
                return "error";
            }
            if (map == null || map.isEmpty()) throw new Exception("There is no on-going or finished release operation with id " + this.releaseId);
            int state = DistributedReleaseUtil.getReleaseState((Map)map);
            status = state == 1 ? "inProgress" : (state == 3 ? "success" : "initialized");
            if (status.equals("success") && (result2 = releaseManager.getReleaseResult(this.releaseId)) != null && this.getContinuum().getContinuumReleaseResult(this.projectId, this.releaseGoal, result2.getStartTime(), result2.getEndTime()) == null) {
                ContinuumReleaseResult releaseResult = this.createContinuumReleaseResult(result2);
                this.getContinuum().addContinuumReleaseResult(releaseResult);
            }
            this.listenerSummary.setPhases(DistributedReleaseUtil.getReleasePhases((Map)map));
            this.listenerSummary.setCompletedPhases(DistributedReleaseUtil.getCompletedReleasePhases((Map)map));
            this.listenerSummary.setInProgress(DistributedReleaseUtil.getReleaseInProgress((Map)map));
            this.listenerSummary.setError(DistributedReleaseUtil.getReleaseError((Map)map));
            return status;
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        this.listener = (ContinuumReleaseManagerListener)releaseManager.getListeners().get(this.releaseId);
        if (this.listener == null) {
            throw new Exception("There is no on-going or finished release operation with id " + this.releaseId);
        }
        status = this.listener.getState() == 1 ? "inProgress" : (this.listener.getState() == 3 ? "success" : "initialized");
        this.listenerSummary.setPhases(this.listener.getPhases());
        this.listenerSummary.setCompletedPhases(this.listener.getCompletedPhases());
        this.listenerSummary.setInProgress(this.listener.getInProgress());
        this.listenerSummary.setError(this.listener.getError());
        if (!status.equals("success") || (result = (ReleaseResult)releaseManager.getReleaseResults().get(this.releaseId)) == null || this.getContinuum().getContinuumReleaseResult(this.projectId, this.releaseGoal, result.getStartTime(), result.getEndTime()) != null) return status;
        ContinuumReleaseResult releaseResult = this.createContinuumReleaseResult(result);
        this.getContinuum().addContinuumReleaseResult(releaseResult);
        return status;
    }

    public String viewResult() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.listenerSummary = new ReleaseListenerSummary();
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            DistributedReleaseManager releaseManager = this.getContinuum().getDistributedReleaseManager();
            try {
                Map map = releaseManager.getListener(this.releaseId);
                if (map != null && !map.isEmpty()) {
                    int state = DistributedReleaseUtil.getReleaseState((Map)map);
                    this.listenerSummary.setPhases(DistributedReleaseUtil.getReleasePhases((Map)map));
                    this.listenerSummary.setCompletedPhases(DistributedReleaseUtil.getCompletedReleasePhases((Map)map));
                    this.listenerSummary.setInProgress(DistributedReleaseUtil.getReleaseInProgress((Map)map));
                    this.listenerSummary.setError(DistributedReleaseUtil.getReleaseError((Map)map));
                    if (state == 3) {
                        this.result = releaseManager.getReleaseResult(this.releaseId);
                        return "success";
                    }
                    throw new Exception("The release operation with id " + this.releaseId + "has not finished yet.");
                }
                throw new Exception("There is no finished release operation with id " + this.releaseId);
            }
            catch (BuildAgentConfigurationException e) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(e.getMessage());
                this.addActionError(this.getText("releaseViewResult.error", args));
                return "error";
            }
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        this.listener = (ContinuumReleaseManagerListener)releaseManager.getListeners().get(this.releaseId);
        if (this.listener != null) {
            this.listenerSummary.setPhases(this.listener.getPhases());
            this.listenerSummary.setCompletedPhases(this.listener.getCompletedPhases());
            this.listenerSummary.setInProgress(this.listener.getInProgress());
            this.listenerSummary.setError(this.listener.getError());
            if (this.listener.getState() == 3) {
                this.result = (ReleaseResult)releaseManager.getReleaseResults().get(this.releaseId);
                return "success";
            }
            throw new Exception("The release operation with id " + this.releaseId + "has not finished yet.");
        }
        throw new Exception("There is no finished release operation with id " + this.releaseId);
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public ContinuumReleaseManagerListener getListener() {
        return this.listener;
    }

    public void setListener(ContinuumReleaseManagerListener listener) {
        this.listener = listener;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getReleaseGoal() {
        return this.releaseGoal;
    }

    public void setReleaseGoal(String releaseGoal) {
        this.releaseGoal = releaseGoal;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public ReleaseListenerSummary getListenerSummary() {
        return this.listenerSummary;
    }

    public void setListenerSummary(ReleaseListenerSummary listenerSummary) {
        this.listenerSummary = listenerSummary;
    }

    private ContinuumReleaseResult createContinuumReleaseResult(ReleaseResult result) throws ContinuumException {
        ContinuumReleaseResult releaseResult = new ContinuumReleaseResult();
        releaseResult.setStartTime(result.getStartTime());
        releaseResult.setEndTime(result.getEndTime());
        releaseResult.setResultCode(result.getResultCode());
        Project project = this.getContinuum().getProject(this.projectId);
        ProjectGroup projectGroup = project.getProjectGroup();
        releaseResult.setProjectGroup(projectGroup);
        releaseResult.setProject(project);
        releaseResult.setReleaseGoal(this.releaseGoal);
        String releaseName = "releases-" + result.getStartTime();
        try {
            File logFile = this.getContinuum().getConfiguration().getReleaseOutputFile(projectGroup.getId(), releaseName);
            PrintWriter writer = new PrintWriter(new FileWriter(logFile));
            writer.write(result.getOutput());
            writer.close();
        }
        catch (ConfigurationException e) {
            throw new ContinuumException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ContinuumException("Unable to write output to file", (Throwable)e);
        }
        return releaseResult;
    }

    public String getProjectName() throws ContinuumException {
        return this.getProjectGroupName();
    }
}

