/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.Date;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectViewAction
extends ContinuumActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(ProjectViewAction.class);
    private Project project;
    private int projectId;
    private String lastBuildDateTime;

    public String execute() throws ContinuumException {
        ProjectGroup projectGroup = this.getProjectGroup();
        try {
            this.checkViewProjectGroupAuthorization(projectGroup.getName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        if (this.project.getLatestBuildId() > 0) {
            try {
                BuildResult lastBuildResult = this.getContinuum().getBuildResult(this.project.getLatestBuildId());
                if (lastBuildResult != null) {
                    this.setLastBuildDateTime(this.dateFormatter.format(new Date(lastBuildResult.getEndTime())));
                }
            }
            catch (ContinuumException e) {
                logger.info("buildResult with id " + this.project.getLatestBuildId() + " has been deleted");
            }
        }
        return "success";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.project;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public ProjectGroup getProjectGroup() throws ContinuumException {
        return this.getContinuum().getProjectGroupByProjectId(this.projectId);
    }

    public String getLastBuildDateTime() {
        return this.lastBuildDateTime;
    }

    public void setLastBuildDateTime(String lastBuildDateTime) {
        this.lastBuildDateTime = lastBuildDateTime;
    }
}

