/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.buildmanager.BuildsManager;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.maven.continuum.web.bean.ProjectGroupUserBean;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectGroupAction
extends ContinuumConfirmAction {
    private static final Logger logger = LoggerFactory.getLogger(ProjectGroupAction.class);
    private static final Map<String, String> FILTER_CRITERIA = new HashMap();
    private RBACManager rbac;
    private RoleManager roleManager;
    private BuildsManager parallelBuildsManager;
    private int projectGroupId;
    private ProjectGroup projectGroup;
    private String name;
    private String description;
    private Map projects = new HashMap();
    private Map<Integer, String> projectGroups = new HashMap();
    private boolean confirmed;
    private boolean projectInCOQueue = false;
    private Collection<Project> projectList;
    private List<ProjectGroupUserBean> projectGroupUsers;
    private String filterProperty;
    private String filterKey;
    private String sorterProperty = "username";
    private boolean ascending = true;
    private Collection groupProjects;
    private int releaseProjectId;
    private Map<String, Integer> buildDefinitions;
    private int buildDefinitionId;
    private boolean fromSummaryPage = false;
    private String preferredExecutor = "maven2";
    private String url;
    private int repositoryId;
    private List<LocalRepository> repositories;
    private boolean disabledRepositories = true;
    private List<ProjectScmRoot> projectScmRoots;

    public String summary() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (ContinuumException e) {
            this.addActionError(this.getText("projectGroup.invalid.id", "Invalid Project Group Id: " + this.projectGroupId, Integer.toString(this.projectGroupId)));
            return "to_summary_page";
        }
        this.projectGroup = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId);
        List projectGroupBuildDefs = this.getContinuum().getBuildDefinitionsForProjectGroup(this.projectGroupId);
        if (projectGroupBuildDefs != null) {
            this.buildDefinitions = new LinkedHashMap(projectGroupBuildDefs.size());
            for (BuildDefinition buildDefinition : projectGroupBuildDefs) {
                if (buildDefinition.isDefaultForProject()) continue;
                String key = StringUtils.isEmpty((String)buildDefinition.getDescription()) ? buildDefinition.getGoals() : buildDefinition.getDescription();
                this.buildDefinitions.put(key, buildDefinition.getId());
            }
        } else {
            this.buildDefinitions = Collections.EMPTY_MAP;
        }
        if (this.projectGroup != null) {
            if (this.projectGroup.getProjects() != null && this.projectGroup.getProjects().size() > 0) {
                int nbMaven2Projects = 0;
                int nbMaven1Projects = 0;
                int nbAntProjects = 0;
                int nbShellProjects = 0;
                Project rootProject = (Project)this.getContinuum().getProjectsInBuildOrder(this.getContinuum().getProjectsInGroupWithDependencies(this.projectGroupId)).get(0);
                if ("maven2".equals(rootProject.getExecutorId()) || "maven-1".equals(rootProject.getExecutorId())) {
                    this.url = rootProject.getUrl();
                }
                for (Project o : this.projectGroup.getProjects()) {
                    Project p = o;
                    if ("maven2".equals(p.getExecutorId())) {
                        ++nbMaven2Projects;
                        continue;
                    }
                    if ("maven-1".equals(p.getExecutorId())) {
                        ++nbMaven1Projects;
                        continue;
                    }
                    if ("ant".equals(p.getExecutorId())) {
                        ++nbAntProjects;
                        continue;
                    }
                    if (!"shell".equals(p.getExecutorId())) continue;
                    ++nbShellProjects;
                }
                int nbActualPreferredProject = nbMaven2Projects;
                if (nbMaven1Projects > nbActualPreferredProject) {
                    this.preferredExecutor = "maven-1";
                    nbActualPreferredProject = nbMaven1Projects;
                }
                if (nbAntProjects > nbActualPreferredProject) {
                    this.preferredExecutor = "ant";
                    nbActualPreferredProject = nbAntProjects;
                }
                if (nbShellProjects > nbActualPreferredProject) {
                    this.preferredExecutor = "shell";
                }
            }
            this.projectScmRoots = this.getContinuum().getProjectScmRootByProjectGroup(this.projectGroup.getId());
        }
        return "success";
    }

    public String members() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.projectGroup = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId);
        this.groupProjects = this.projectGroup.getProjects();
        this.populateProjectGroupUsers(this.projectGroup);
        return "success";
    }

    public Collection getGroupProjects() throws ContinuumException {
        return this.groupProjects;
    }

    public String buildDefinitions() throws ContinuumException {
        return this.summary();
    }

    public String notifiers() throws ContinuumException {
        return this.summary();
    }

    public String remove() throws ContinuumException {
        try {
            this.checkRemoveProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        if (this.confirmed) {
            try {
                this.getContinuum().removeProjectGroup(this.projectGroupId);
            }
            catch (ContinuumException e) {
                logger.error("Error while removing project group with id " + this.projectGroupId, (Throwable)e);
                this.addActionError(this.getText("projectGroup.delete.error", "Unable to remove project group", Integer.toString(this.projectGroupId)));
            }
        } else {
            this.name = this.getProjectGroupName();
            return "confirm";
        }
        AuditLog event = new AuditLog("Project Group id=" + this.projectGroupId, "Removed Project Group");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    private void initialize() throws ContinuumException {
        try {
            this.checkManageLocalRepositoriesAuthorization();
            this.disabledRepositories = false;
        }
        catch (AuthorizationRequiredException authzE) {
            // empty catch block
        }
        this.projectGroup = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId);
        this.projectList = this.projectGroup.getProjects();
        if (this.projectList != null) {
            for (Project p : this.projectList) {
                try {
                    if (this.parallelBuildsManager.isInAnyCheckoutQueue(p.getId())) {
                        this.projectInCOQueue = true;
                    }
                }
                catch (BuildManagerException e) {
                    throw new ContinuumException(e.getMessage(), (Throwable)e);
                }
                this.projects.put(p, p.getProjectGroup().getId());
            }
        }
        for (ProjectGroup pg : this.getContinuum().getAllProjectGroups()) {
            if (!this.isAuthorized(this.projectGroup.getName())) continue;
            this.projectGroups.put(pg.getId(), pg.getName());
        }
        this.repositories = this.getContinuum().getRepositoryService().getAllLocalRepositories();
    }

    public String edit() throws ContinuumException {
        Project rootProject;
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.initialize();
        this.name = this.projectGroup.getName();
        this.description = this.projectGroup.getDescription();
        this.projectList = this.projectGroup.getProjects();
        this.repositoryId = this.projectGroup.getLocalRepository() != null ? this.projectGroup.getLocalRepository().getId() : -1;
        Collection projList = this.getContinuum().getProjectsInGroupWithDependencies(this.projectGroup.getId());
        if (projList != null && projList.size() > 0 && (rootProject = (Project)this.getContinuum().getProjectsInBuildOrder(projList).get(0)) != null) {
            this.setUrl(rootProject.getUrl());
        }
        return "success";
    }

    public String save() throws Exception {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        if (this.name != null) {
            if (this.name.equals("")) {
                this.addActionError(this.getText("projectGroup.error.name.required"));
            } else if (this.name.trim().equals("")) {
                this.addActionError(this.getText("projectGroup.error.name.cannot.be.spaces"));
            } else {
                this.name = this.name.trim();
                for (ProjectGroup projectGroup : this.getContinuum().getAllProjectGroups()) {
                    if (!this.name.equals(projectGroup.getName()) || projectGroup.getId() == this.projectGroupId) continue;
                    this.addActionError(this.getText("projectGroup.error.name.already.exists"));
                }
            }
            if (this.hasActionErrors()) {
                this.initialize();
                return "input";
            }
        }
        this.projectGroup = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId);
        if (!this.name.equals(this.projectGroup.getName())) {
            this.name = this.name.trim();
            try {
                this.roleManager.updateRole("project-administrator", this.projectGroup.getName(), this.name);
                this.roleManager.updateRole("project-developer", this.projectGroup.getName(), this.name);
                this.roleManager.updateRole("project-user", this.projectGroup.getName(), this.name);
                this.projectGroup.setName(this.name);
            }
            catch (RoleManagerException e) {
                throw new ContinuumException("unable to rename the project group", (Throwable)e);
            }
        }
        this.projectGroup.setDescription(this.description);
        if (this.repositoryId > 0) {
            LocalRepository repository = this.getContinuum().getRepositoryService().getLocalRepository(this.repositoryId);
            this.projectGroup.setLocalRepository(repository);
        }
        this.getContinuum().updateProjectGroup(this.projectGroup);
        Collection projectList = this.getContinuum().getProjectsInGroupWithDependencies(this.projectGroupId);
        if (projectList != null && projectList.size() > 0) {
            Project rootProject = (Project)this.getContinuum().getProjectsInBuildOrder(projectList).get(0);
            rootProject.setUrl(this.url);
            this.getContinuum().updateProject(rootProject);
        }
        for (String key : this.projects.keySet()) {
            String[] id = (String[])this.projects.get(key);
            int projectId = Integer.parseInt(key);
            Project project = null;
            Iterator i = this.projectGroup.getProjects().iterator();
            while (i.hasNext() && projectId != (project = (Project)i.next()).getId()) {
            }
            ProjectGroup newProjectGroup = this.getContinuum().getProjectGroupWithProjects(new Integer(id[0]).intValue());
            if (newProjectGroup.getId() == this.projectGroup.getId() || !this.isAuthorized(newProjectGroup.getName())) continue;
            logger.info("Moving project " + project.getName() + " to project group " + newProjectGroup.getName());
            project.setProjectGroup(newProjectGroup);
            Collection results = this.getContinuum().getBuildResultsForProject(project.getId());
            for (BuildResult br : results) {
                this.getContinuum().removeBuildResult(br.getId());
            }
            this.getContinuum().updateProject(project);
        }
        AuditLog event = new AuditLog("Project Group id=" + this.projectGroupId, "Modified Project Group");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public String build() throws ContinuumException {
        try {
            this.checkBuildProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        if (this.getBuildDefinitionId() == -1) {
            this.getContinuum().buildProjectGroup(this.projectGroupId);
        } else {
            this.getContinuum().buildProjectGroupWithBuildDefinition(this.projectGroupId, this.buildDefinitionId);
        }
        AuditLog event = new AuditLog("Project Group id=" + this.projectGroupId, "Forced Project Build");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        if (this.isFromSummaryPage()) {
            return "to_summary_page";
        }
        return "success";
    }

    public String release() throws ContinuumException {
        try {
            this.checkBuildProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        Project parent = null;
        boolean allBuildsOk = true;
        boolean allMavenTwo = true;
        this.projectList = this.getContinuum().getProjectsInGroupWithDependencies(this.projectGroupId);
        if (this.projectList != null) {
            for (Project p : this.projectList) {
                if (p.getState() != 2) {
                    allBuildsOk = false;
                }
                if (p.getParent() == null || !this.isParentInProjectGroup(p.getParent(), this.projectList)) {
                    if (parent == null) {
                        parent = p;
                    } else {
                        this.addActionError(this.getText("projectGroup.release.error.severalParentProjects"));
                        return "input";
                    }
                }
                if ("maven2".equals(p.getExecutorId())) continue;
                allMavenTwo = false;
            }
        }
        if (parent == null) {
            this.addActionError(this.getText("projectGroup.release.error.emptyGroup"));
            return "input";
        }
        this.releaseProjectId = parent.getId();
        if (allBuildsOk && allMavenTwo) {
            return "success";
        }
        this.addActionError(this.getText("projectGroup.release.error.projectNotInSuccess"));
        return "input";
    }

    private boolean isParentInProjectGroup(ProjectDependency parent, Collection<Project> projectsInGroup) throws ContinuumException {
        boolean result = false;
        for (Project project : projectsInGroup) {
            if (parent == null || !project.getArtifactId().equals(parent.getArtifactId()) || !project.getGroupId().equals(parent.getGroupId()) || !project.getVersion().equals(parent.getVersion())) continue;
            result = true;
        }
        return result;
    }

    private void populateProjectGroupUsers(ProjectGroup group) {
        List<User> users = new ArrayList();
        try {
            List roles = this.rbac.getAllRoles();
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Role r : roles) {
                if (r.getName().indexOf(this.projectGroup.getName()) <= -1) continue;
                roleNames.add(r.getName());
            }
            List userAssignments = this.rbac.getUserAssignmentsForRoles(roleNames);
            for (UserAssignment ua : userAssignments) {
                User u = this.getSecuritySystem().getUserManager().findUser(ua.getPrincipal());
                if (u == null) continue;
                users.add(u);
            }
        }
        catch (Exception e) {
            logger.error("Can't get the users list", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)this.filterKey)) {
            users = this.findUsers(users, this.filterProperty, this.filterKey);
        }
        if (StringUtils.isNotBlank((String)this.sorterProperty)) {
            this.sortUsers(users, this.sorterProperty, this.ascending);
        }
        this.projectGroupUsers = new ArrayList();
        if (users == null) {
            return;
        }
        for (User user : users) {
            ProjectGroupUserBean pgUser = new ProjectGroupUserBean();
            pgUser.setUser(user);
            pgUser.setProjectGroup(group);
            try {
                Collection effectiveRoles = this.rbac.getEffectivelyAssignedRoles(user.getUsername());
                for (Role role : effectiveRoles) {
                    if (role.getName().indexOf(this.projectGroup.getName()) <= -1) continue;
                    pgUser.setRoles(effectiveRoles);
                    this.projectGroupUsers.add(pgUser);
                }
            }
            catch (RbacObjectNotFoundException e) {
                pgUser.setRoles((Collection)Collections.EMPTY_LIST);
            }
            catch (RbacManagerException e) {
                pgUser.setRoles((Collection)Collections.EMPTY_LIST);
            }
        }
    }

    private List<User> findUsers(List<User> users, String searchProperty, String searchKey) {
        ArrayList<User> userList = new ArrayList<User>();
        for (User user : users) {
            String email;
            if ("username".equals(searchProperty)) {
                String username = user.getUsername();
                if (username == null || username.toLowerCase().indexOf(searchKey.toLowerCase()) < 0) continue;
                userList.add(user);
                continue;
            }
            if ("fullName".equals(searchProperty)) {
                String fullname = user.getFullName();
                if (fullname == null || fullname.toLowerCase().indexOf(searchKey.toLowerCase()) < 0) continue;
                userList.add(user);
                continue;
            }
            if (!"email".equals(searchProperty) || (email = user.getEmail()) == null || email.toLowerCase().indexOf(searchKey.toLowerCase()) < 0) continue;
            userList.add(user);
        }
        return userList;
    }

    private void sortUsers(List<User> userList, String sorterProperty, boolean orderAscending) {
        Collections.sort(userList, new /* Unavailable Anonymous Inner Class!! */);
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public ProjectGroup getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getProjects() {
        return this.projects;
    }

    public void setProjects(Map projects) {
        this.projects = projects;
    }

    public Map<Integer, String> getProjectGroups() {
        return this.projectGroups;
    }

    public void setProjectGroups(Map<Integer, String> projectGroups) {
        this.projectGroups = projectGroups;
    }

    public boolean isProjectInCOQueue() {
        return this.projectInCOQueue;
    }

    public void setProjectInCOQueue(boolean projectInQueue) {
        this.projectInCOQueue = projectInQueue;
    }

    public Collection<Project> getProjectList() {
        return this.projectList;
    }

    public List<ProjectGroupUserBean> getProjectGroupUsers() {
        return this.projectGroupUsers;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getFilterKey() {
        return this.filterKey;
    }

    public void setFilterKey(String filterKey) {
        this.filterKey = filterKey;
    }

    public String getFilterProperty() {
        return this.filterProperty;
    }

    public void setFilterProperty(String filterProperty) {
        this.filterProperty = filterProperty;
    }

    public Map<String, String> getCriteria() {
        return FILTER_CRITERIA;
    }

    public void setReleaseProjectId(int releaseProjectId) {
        this.releaseProjectId = releaseProjectId;
    }

    public int getReleaseProjectId() {
        return this.releaseProjectId;
    }

    public ProjectGroup getProjectGroup(int projectGroupId) throws ContinuumException {
        if (this.projectGroup == null) {
            this.projectGroup = this.getContinuum().getProjectGroup(projectGroupId);
        } else if (this.projectGroup.getId() != projectGroupId) {
            this.projectGroup = this.getContinuum().getProjectGroup(projectGroupId);
        }
        return this.projectGroup;
    }

    public String getProjectGroupName() throws ContinuumException {
        return this.getProjectGroup(this.projectGroupId).getName();
    }

    public Map<String, Integer> getBuildDefinitions() {
        return this.buildDefinitions;
    }

    public void setBuildDefinitions(Map<String, Integer> buildDefinitions) {
        this.buildDefinitions = buildDefinitions;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public boolean isFromSummaryPage() {
        return this.fromSummaryPage;
    }

    public void setFromSummaryPage(boolean fromSummaryPage) {
        this.fromSummaryPage = fromSummaryPage;
    }

    public String getPreferredExecutor() {
        return this.preferredExecutor;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    public List<LocalRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<LocalRepository> repositories) {
        this.repositories = repositories;
    }

    public boolean isDisabledRepositories() {
        return this.disabledRepositories;
    }

    public void setDisabledRepositories(boolean disabledRepositories) {
        this.disabledRepositories = disabledRepositories;
    }

    public List<ProjectScmRoot> getProjectScmRoots() {
        return this.projectScmRoots;
    }

    public void setProjectScmRoots(List<ProjectScmRoot> projectScmRoots) {
        this.projectScmRoots = projectScmRoots;
    }

    private boolean isAuthorized(String projectGroupName) {
        try {
            this.checkAddProjectToGroupAuthorization(projectGroupName);
            return true;
        }
        catch (AuthorizationRequiredException authzE) {
            return false;
        }
    }

    public String getSorterProperty() {
        return this.sorterProperty;
    }

    public void setSorterProperty(String sorterProperty) {
        this.sorterProperty = sorterProperty;
    }

    static {
        FILTER_CRITERIA.put("username", "Username contains");
        FILTER_CRITERIA.put("fullName", "Name contains");
        FILTER_CRITERIA.put("email", "Email contains");
    }
}

