/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

public class ProjectEditAction
extends ContinuumActionSupport {
    private Project project;
    private int projectId;
    private String name;
    private String version;
    private String scmUrl;
    private String scmUsername;
    private String scmPassword;
    private String scmTag;
    private boolean scmUseCache;

    public String save() throws ContinuumException {
        try {
            this.checkModifyProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getProject(this.projectId);
        this.project.setName(this.name);
        this.project.setVersion(this.version);
        this.project.setScmUrl(this.scmUrl);
        this.project.setScmUseCache(this.scmUseCache);
        this.project.setScmUsername(this.scmUsername);
        this.project.setScmPassword(this.scmPassword);
        this.project.setScmTag(this.scmTag);
        this.getContinuum().updateProject(this.project);
        AuditLog event = new AuditLog("Project id=" + this.projectId, "Modified Project");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public String edit() throws ContinuumException {
        try {
            this.checkModifyProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getProject(this.projectId);
        this.name = this.project.getName();
        this.version = this.project.getVersion();
        this.scmUrl = this.project.getScmUrl();
        this.scmUsername = this.project.getScmUsername();
        this.scmPassword = this.project.getScmPassword();
        this.scmUseCache = this.project.isScmUseCache();
        this.scmTag = this.project.getScmTag();
        return "success";
    }

    private Project getProject(int projectId) throws ContinuumException {
        return this.getContinuum().getProject(projectId);
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public Project getProject() {
        return this.project;
    }

    public void setScmUseCache(boolean scmUseCache) {
        this.scmUseCache = scmUseCache;
    }

    public boolean isScmUseCache() {
        return this.scmUseCache;
    }

    public String getProjectGroupName() throws ContinuumException {
        return this.getProject(this.projectId).getProjectGroup().getName();
    }
}

