/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.continuum.model.project.ProjectGroupSummary;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.GroupSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSummaryAction
extends ContinuumActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(GroupSummaryAction.class);
    private String infoMessage;
    private List<GroupSummary> groups;

    public String execute() throws ContinuumException {
        this.groups = new ArrayList();
        List projectGroups = this.getContinuum().getAllProjectGroups();
        Map summaries = this.getContinuum().getProjectsSummaryByGroups();
        for (ProjectGroup projectGroup : projectGroups) {
            if (!this.isAuthorized(projectGroup.getName())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("GroupSummaryAction: building group " + projectGroup.getName());
            }
            GroupSummary groupModel = new GroupSummary();
            groupModel.setId(projectGroup.getId());
            groupModel.setGroupId(projectGroup.getGroupId());
            groupModel.setName(projectGroup.getName());
            groupModel.setDescription(projectGroup.getDescription());
            ProjectGroupSummary summary = (ProjectGroupSummary)summaries.get(projectGroup.getId());
            if (summary != null) {
                groupModel.setNumProjects(summary.getNumberOfProjects());
                groupModel.setNumErrors(summary.getNumberOfErrors());
                groupModel.setNumFailures(summary.getNumberOfFailures());
                groupModel.setNumSuccesses(summary.getNumberOfSuccesses());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("GroupSummaryAction: adding group to groups list " + groupModel.getName());
            }
            this.groups.add(groupModel);
        }
        return "success";
    }

    public List<GroupSummary> getGroups() {
        return this.groups;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String infoMessage) {
        this.infoMessage = infoMessage;
    }

    private boolean isAuthorized(String projectGroupName) {
        try {
            this.checkViewProjectGroupAuthorization(projectGroupName);
            return true;
        }
        catch (AuthorizationRequiredException authzE) {
            return false;
        }
    }
}

