/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProjectAction
extends ContinuumActionSupport {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int projectId;
    private String projectName;
    private int projectGroupId;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkRemoveProjectFromGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        AuditLog event = new AuditLog("Project id=" + this.projectId, "Removed Project");
        event.setCurrentUser(this.getPrincipal());
        event.setCategory("PROJECT");
        event.log();
        try {
            this.getContinuum().removeProject(this.projectId);
        }
        catch (ContinuumException e) {
            this.logger.error("Error removing project with id " + this.projectId, (Throwable)e);
            this.addActionError(this.getText("deleteProject.error", "Unable to delete project", new Integer(this.projectId).toString()));
        }
        return "success";
    }

    public String doDefault() throws ContinuumException {
        try {
            this.checkRemoveProjectFromGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        Project project = this.getContinuum().getProject(this.projectId);
        this.projectName = project.getName();
        return "delete";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

