/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.apache.maven.continuum.Continuum;
import org.apache.maven.continuum.web.action.PlexusActionSupport;
import org.apache.maven.continuum.web.exception.AuthenticationRequiredException;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.util.StringUtils;

public class ContinuumActionSupport
extends PlexusActionSupport
implements Preparable {
    private SecuritySession securitySession;
    private SecuritySystem securitySystem;
    protected static final String REQUIRES_AUTHENTICATION = "requires-authentication";
    protected static final String REQUIRES_AUTHORIZATION = "requires-authorization";
    protected static final String ERROR_MSG_AUTHORIZATION_REQUIRED = "You are not authorized to access this page. Please contact your administrator to be granted the appropriate permissions.";
    protected static final String ERROR_MSG_PROCESSING_AUTHORIZATION = "An error occurred while performing authorization.";
    private Continuum continuum;
    protected final SimpleDateFormat dateFormatter = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa z");

    public void prepare() throws Exception {
        if (this.securitySession == null) {
            this.securitySession = (SecuritySession)this.getContext().getSession().get("securitySession");
        }
    }

    public Continuum getContinuum() {
        return this.continuum;
    }

    public void setContinuum(Continuum continuum) {
        this.continuum = continuum;
    }

    public String doDefault() throws Exception {
        return REQUIRES_AUTHORIZATION;
    }

    public String input() throws Exception {
        return REQUIRES_AUTHORIZATION;
    }

    public String execute() throws Exception {
        return REQUIRES_AUTHORIZATION;
    }

    protected void checkAuthorization(String role) throws AuthorizationRequiredException {
        this.checkAuthorization(role, null, false);
    }

    protected void checkAuthorization(String role, String resource) throws AuthorizationRequiredException {
        this.checkAuthorization(role, resource, true);
    }

    protected void checkAuthorization(String role, String resource, boolean requiredResource) throws AuthorizationRequiredException {
        try {
            if (resource != null && StringUtils.isNotEmpty((String)resource.trim()) ? !this.getSecuritySystem().isAuthorized(this.getSecuritySession(), (Object)role, (Object)resource) : requiredResource || !this.getSecuritySystem().isAuthorized(this.getSecuritySession(), (Object)role)) {
                throw new AuthorizationRequiredException(ERROR_MSG_AUTHORIZATION_REQUIRED);
            }
        }
        catch (AuthorizationException ae) {
            throw new AuthorizationRequiredException(ERROR_MSG_PROCESSING_AUTHORIZATION);
        }
    }

    protected void checkViewProjectGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-view-group", resource);
    }

    protected void checkAddProjectGroupAuthorization() throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-group");
    }

    protected void checkRemoveProjectGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-group", resource);
    }

    protected void checkBuildProjectGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-build-group", resource);
    }

    protected void checkModifyProjectGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-group", resource);
    }

    protected void checkAddProjectToGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-project-to-group", resource);
    }

    protected void checkRemoveProjectFromGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-project-from-group", resource);
    }

    protected void checkModifyProjectInGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-project-in-group", resource);
    }

    protected void checkBuildProjectInGroupAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-build-project-in-group", resource);
    }

    protected void checkAddGroupBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-group-build-definition", resource);
    }

    protected void checkRemoveGroupBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-group-build-definition", resource);
    }

    protected void checkModifyGroupBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-group-build-definition", resource);
    }

    protected void checkAddProjectBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-project-build-definition", resource);
    }

    protected void checkModifyProjectBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-project-build-definition", resource);
    }

    protected void checkRemoveProjectBuildDefinitionAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-project-build-definition", resource);
    }

    protected void checkAddProjectGroupNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-group-notifier", resource);
    }

    protected void checkRemoveProjectGroupNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-group-notifier", resource);
    }

    protected void checkModifyProjectGroupNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-group-notifier", resource);
    }

    protected void checkAddProjectNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-add-project-notifier", resource);
    }

    protected void checkRemoveProjectNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-remove-project-notifier", resource);
    }

    protected void checkModifyProjectNotifierAuthorization(String resource) throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-modify-project-notifier", resource);
    }

    protected void checkManageConfigurationAuthorization() throws AuthenticationRequiredException, AuthorizationRequiredException {
        if (!this.isAuthenticated()) {
            throw new AuthenticationRequiredException("Authentication required.");
        }
        this.checkAuthorization("continuum-manage-configuration");
    }

    protected void checkManageSchedulesAuthorization() throws AuthenticationRequiredException, AuthorizationRequiredException {
        if (!this.isAuthenticated()) {
            throw new AuthenticationRequiredException("Authentication required.");
        }
        this.checkAuthorization("continuum-manage-schedules");
    }

    protected void checkManageQueuesAuthorization() throws AuthenticationRequiredException, AuthorizationRequiredException {
        if (!this.isAuthenticated()) {
            throw new AuthenticationRequiredException("Authentication required");
        }
        this.checkAuthorization("continuum-manage-queues");
    }

    protected void checkManageLocalRepositoriesAuthorization() throws AuthorizationRequiredException {
        this.checkAuthorization("continuum-manage-repositories");
    }

    private SecuritySession getSecuritySession() {
        return this.securitySession;
    }

    private ActionContext getContext() {
        return ActionContext.getContext();
    }

    protected SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    protected boolean requiresAuthentication() {
        return true;
    }

    public boolean isAuthenticated() {
        return !this.requiresAuthentication() || this.getSecuritySession() != null && this.getSecuritySession().isAuthenticated();
    }

    protected ResourceBundle getResourceBundle() {
        return this.getTexts("localization/Continuum");
    }

    protected String getPrincipal() {
        String principal = "guest";
        if (this.getSecuritySession() != null) {
            if (this.getSecuritySession().getUser() != null) {
                principal = (String)this.getSecuritySession().getUser().getPrincipal();
            }
        } else {
            principal = "unknown-user";
        }
        return principal;
    }
}

