/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.buildmanager.BuildsManager;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.continuum.taskqueue.BuildProjectTask;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelBuildAction
extends ContinuumActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(CancelBuildAction.class);
    private int projectId;
    private int projectGroupId;
    private List<String> selectedProjects;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
            BuildsManager buildsManager = this.getContinuum().getBuildsManager();
            buildsManager.cancelBuild(this.projectId);
            AuditLog event = new AuditLog("Project id=" + this.projectId, "Cancelled Project Build");
            event.setCategory("PROJECT");
            event.setCurrentUser(this.getPrincipal());
            event.log();
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        catch (BuildManagerException e) {
            throw new ContinuumException("Error while canceling build", (Throwable)e);
        }
        return "success";
    }

    public String cancelBuilds() throws ContinuumException {
        if (this.getSelectedProjects() == null || this.getSelectedProjects().isEmpty()) {
            return "success";
        }
        int[] projectsId = new int[this.getSelectedProjects().size()];
        for (String selectedProjectId : this.getSelectedProjects()) {
            int projectId = Integer.parseInt(selectedProjectId);
            projectsId = ArrayUtils.add((int[])projectsId, (int)projectId);
        }
        BuildsManager parallelBuildsManager = this.getContinuum().getBuildsManager();
        parallelBuildsManager.removeProjectsFromBuildQueue(projectsId);
        try {
            int index = ArrayUtils.indexOf((int[])projectsId, (int)this.getCurrentProjectIdBuilding());
            if (index > 0) {
                int projId = projectsId[index];
                this.getContinuum().getBuildsManager().cancelBuild(projId);
                AuditLog event = new AuditLog("Project id=" + projId, "Cancelled Project Build");
                event.setCategory("PROJECT");
                event.setCurrentUser(this.getPrincipal());
                event.log();
            }
        }
        catch (BuildManagerException e) {
            logger.error(e.getMessage());
            throw new ContinuumException(e.getMessage(), (Throwable)e);
        }
        return "success";
    }

    public String cancelGroupBuild() throws ContinuumException {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getContinuum().getProjectGroup(this.projectGroupId).getName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        BuildsManager buildsManager = this.getContinuum().getBuildsManager();
        List scmRoots = this.getContinuum().getProjectScmRootByProjectGroup(this.projectGroupId);
        if (scmRoots != null) {
            for (ProjectScmRoot scmRoot : scmRoots) {
                try {
                    buildsManager.removeProjectGroupFromPrepareBuildQueue(this.projectGroupId, scmRoot.getScmRootAddress());
                }
                catch (BuildManagerException e) {
                    throw new ContinuumException("Unable to cancel group build", (Throwable)e);
                }
            }
        }
        Collection projects = this.getContinuum().getProjectsInGroup(this.projectGroupId);
        ArrayList<String> projectIds = new ArrayList<String>();
        for (Project project : projects) {
            projectIds.add(Integer.toString(project.getId()));
        }
        this.setSelectedProjects(projectIds);
        return this.cancelBuilds();
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public List<String> getSelectedProjects() {
        return this.selectedProjects;
    }

    public void setSelectedProjects(List<String> selectedProjects) {
        this.selectedProjects = selectedProjects;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    protected int getCurrentProjectIdBuilding() throws ContinuumException, BuildManagerException {
        Map currentBuilds = this.getContinuum().getBuildsManager().getCurrentBuilds();
        Set keySet = currentBuilds.keySet();
        for (String key : keySet) {
            BuildProjectTask task = (BuildProjectTask)currentBuilds.get(key);
            if (task == null) continue;
            return task.getProjectId();
        }
        return -1;
    }
}

