/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.AbstractBuildAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultsListAction
extends AbstractBuildAction {
    private static final Logger logger = LoggerFactory.getLogger(BuildResultsListAction.class);
    private Project project;
    private Collection<BuildResult> buildResults;
    private Collection<String> selectedBuildResults;
    private int projectId;
    private int projectGroupId;
    private String projectName;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getContinuum().getProject(this.projectId);
        this.buildResults = this.getContinuum().getBuildResultsForProject(this.projectId);
        return "success";
    }

    public String remove() throws ContinuumException {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.isConfirmed()) {
            if (this.selectedBuildResults != null && !this.selectedBuildResults.isEmpty()) {
                for (String id : this.selectedBuildResults) {
                    int buildId = Integer.parseInt(id);
                    try {
                        logger.info("Removing BuildResult with id=" + buildId);
                        this.getContinuum().removeBuildResult(buildId);
                        AuditLog event = new AuditLog("Build Result id=" + buildId, "Removed Build Result");
                        event.setCategory("BUILD_RESULT");
                        event.setCurrentUser(this.getPrincipal());
                        event.log();
                    }
                    catch (ContinuumException e) {
                        logger.error("Error removing BuildResult with id=" + buildId);
                        this.addActionError(this.getText("buildResult.delete.error", "Unable to delete build result", new Integer(buildId).toString()));
                    }
                }
            }
            return "success";
        }
        ArrayList<String> buildResultsRemovable = new ArrayList<String>();
        if (this.selectedBuildResults != null && !this.selectedBuildResults.isEmpty()) {
            for (String id : this.selectedBuildResults) {
                int buildId = Integer.parseInt(id);
                try {
                    if (this.canRemoveBuildResult(this.getContinuum().getBuildResult(buildId))) {
                        buildResultsRemovable.add(Integer.toString(buildId));
                        continue;
                    }
                    this.addActionMessage(this.getResourceBundle().getString("buildResult.cannot.delete"));
                    return "success";
                }
                catch (BuildManagerException e) {
                    logger.error(e.getMessage());
                    throw new ContinuumException(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.setSelectedBuildResults(buildResultsRemovable);
        return "confirm";
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public Collection<BuildResult> getBuildResults() {
        return this.buildResults;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProject(this.projectId).getProjectGroup().getName();
        }
        return this.projectGroupName;
    }

    public Collection<String> getSelectedBuildResults() {
        return this.selectedBuildResults;
    }

    public void setSelectedBuildResults(Collection<String> selectedBuildResults) {
        this.selectedBuildResults = selectedBuildResults;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }
}

