/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.builddefinition.BuildDefinitionServiceException;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.profile.ProfileException;
import org.apache.maven.continuum.profile.ProfileService;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddProjectAction
extends ContinuumActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(AddProjectAction.class);
    private String projectName;
    private String projectDescription;
    private String projectVersion;
    private String projectScmUrl;
    private String projectScmUsername;
    private String projectScmPassword;
    private String projectScmTag;
    private String projectType;
    private Collection<ProjectGroup> projectGroups;
    private int selectedProjectGroup;
    private String projectGroupName;
    private boolean disableGroupSelection;
    private boolean projectScmUseCache;
    private List<Profile> profiles;
    private ProfileService profileService;
    private int projectGroupId;
    private int buildDefintionTemplateId;
    private List<BuildDefinitionTemplate> buildDefinitionTemplates;

    public void validate() {
        this.clearErrorsAndMessages();
        try {
            if (this.projectName.trim().length() <= 0) {
                this.addActionError(this.getText("addProject.name.required"));
            }
            if (this.projectVersion.trim().length() <= 0) {
                this.addActionError(this.getText("addProject.version.required"));
            }
            if (this.projectScmUrl.trim().length() <= 0) {
                this.addActionError(this.getText("addProject.scmUrl.required"));
            }
            if (this.selectedProjectGroup == 0) {
                this.addActionError(this.getText("addProject.projectGroup.required"));
            }
            if (this.hasActionErrors()) {
                this.input();
            }
        }
        catch (ContinuumException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BuildDefinitionServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String add() throws ContinuumException {
        this.initializeProjectGroupName();
        try {
            if (StringUtils.isEmpty((String)this.getProjectGroupName())) {
                this.checkAddProjectGroupAuthorization();
            } else {
                this.checkAddProjectToGroupAuthorization(this.getProjectGroupName());
            }
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        String projectNameTrim = this.projectName.trim();
        String versionTrim = this.projectVersion.trim();
        String scmTrim = this.projectScmUrl.trim();
        for (Project project : this.getContinuum().getProjects()) {
            if (!StringUtils.equalsIgnoreCase((String)project.getName(), (String)projectNameTrim) || !StringUtils.equalsIgnoreCase((String)project.getVersion(), (String)versionTrim) || !StringUtils.equalsIgnoreCase((String)project.getScmUrl(), (String)scmTrim)) continue;
            this.addActionError(this.getText("projectName.already.exist.error"));
            return "input";
        }
        Project project = new Project();
        project.setName(projectNameTrim);
        if (this.projectDescription != null) {
            project.setDescription(this.projectDescription.trim());
        }
        project.setVersion(versionTrim);
        project.setScmUrl(scmTrim);
        project.setScmUsername(this.projectScmUsername);
        project.setScmPassword(this.projectScmPassword);
        project.setScmTag(this.projectScmTag);
        project.setScmUseCache(this.projectScmUseCache);
        project.setExecutorId(this.projectType);
        this.getContinuum().addProject(project, this.projectType, this.selectedProjectGroup, this.getBuildDefintionTemplateId());
        if (this.getSelectedProjectGroup() > 0) {
            this.setProjectGroupId(this.getSelectedProjectGroup());
            return "projectGroupSummary";
        }
        AuditLog event = new AuditLog("Project id=" + project.getId(), "Added Project");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        event.log();
        return "success";
    }

    public String input() throws ContinuumException, ProfileException, BuildDefinitionServiceException {
        try {
            if (StringUtils.isEmpty((String)this.getProjectGroupName())) {
                this.checkAddProjectGroupAuthorization();
            } else {
                this.checkAddProjectToGroupAuthorization(this.getProjectGroupName());
            }
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.projectGroups = new ArrayList();
        List allProjectGroups = this.getContinuum().getAllProjectGroups();
        for (ProjectGroup pg : allProjectGroups) {
            if (!this.isAuthorizedToAddProjectToGroup(pg.getName())) continue;
            this.projectGroups.add(pg);
        }
        this.profiles = this.profileService.getAllProfiles();
        this.buildDefinitionTemplates = this.getContinuum().getBuildDefinitionService().getAllBuildDefinitionTemplate();
        return "input";
    }

    private void initializeProjectGroupName() {
        if (this.disableGroupSelection) {
            try {
                this.projectGroupName = this.getContinuum().getProjectGroup(this.selectedProjectGroup).getName();
            }
            catch (ContinuumException e) {
                e.printStackTrace();
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectScmPassword() {
        return this.projectScmPassword;
    }

    public void setProjectScmPassword(String projectScmPassword) {
        this.projectScmPassword = projectScmPassword;
    }

    public String getProjectScmTag() {
        return this.projectScmTag;
    }

    public void setProjectScmTag(String projectScmTag) {
        this.projectScmTag = projectScmTag;
    }

    public String getProjectScmUrl() {
        return this.projectScmUrl;
    }

    public void setProjectScmUrl(String projectScmUrl) {
        this.projectScmUrl = projectScmUrl;
    }

    public String getProjectScmUsername() {
        return this.projectScmUsername;
    }

    public void setProjectScmUsername(String projectScmUsername) {
        this.projectScmUsername = projectScmUsername;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public Collection<ProjectGroup> getProjectGroups() {
        return this.projectGroups;
    }

    public void setProjectGroups(Collection<ProjectGroup> projectGroups) {
        this.projectGroups = projectGroups;
    }

    public int getSelectedProjectGroup() {
        return this.selectedProjectGroup;
    }

    public void setSelectedProjectGroup(int selectedProjectGroup) {
        this.selectedProjectGroup = selectedProjectGroup;
    }

    public boolean isDisableGroupSelection() {
        return this.disableGroupSelection;
    }

    public void setDisableGroupSelection(boolean disableGroupSelection) {
        this.disableGroupSelection = disableGroupSelection;
    }

    public String getProjectGroupName() {
        return this.projectGroupName;
    }

    public void setProjectGroupName(String projectGroupName) {
        this.projectGroupName = projectGroupName;
    }

    public boolean isProjectScmUseCache() {
        return this.projectScmUseCache;
    }

    public void setProjectScmUseCache(boolean projectScmUseCache) {
        this.projectScmUseCache = projectScmUseCache;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getBuildDefintionTemplateId() {
        return this.buildDefintionTemplateId;
    }

    public void setBuildDefintionTemplateId(int buildDefintionTemplateId) {
        this.buildDefintionTemplateId = buildDefintionTemplateId;
    }

    public List<BuildDefinitionTemplate> getBuildDefinitionTemplates() {
        return this.buildDefinitionTemplates;
    }

    public void setBuildDefinitionTemplates(List<BuildDefinitionTemplate> buildDefinitionTemplates) {
        this.buildDefinitionTemplates = buildDefinitionTemplates;
    }

    private boolean isAuthorizedToAddProjectToGroup(String projectGroupName) {
        try {
            this.checkAddProjectToGroupAuthorization(projectGroupName);
            return true;
        }
        catch (AuthorizationRequiredException authzE) {
            return false;
        }
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }
}

