/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.apache.maven.continuum.web.action.AddMavenProjectAction;

public class AddMavenOneProjectAction
extends AddMavenProjectAction {
    protected ContinuumProjectBuildingResult doExecute(String pomUrl, int selectedProjectGroup, boolean checkProtocol, boolean scmUseCache) throws ContinuumException {
        ContinuumProjectBuildingResult result = this.getContinuum().addMavenOneProject(pomUrl, selectedProjectGroup, checkProtocol, scmUseCache, this.getBuildDefinitionTemplateId());
        AuditLog event = new AuditLog(this.hidePasswordInUrl(pomUrl), "Added M1 Project");
        event.setCategory("PROJECT");
        event.setCurrentUser(this.getPrincipal());
        if (result == null || result.hasErrors()) {
            event.setAction("Failed Adding M1 Project");
        }
        event.log();
        return result;
    }

    public String getM1Pom() {
        return this.getPom();
    }

    public void setM1Pom(String pom) {
        this.setPom(pom);
    }

    public File getM1PomFile() {
        return this.getPomFile();
    }

    public void setM1PomFile(File pomFile) {
        this.setPomFile(pomFile);
    }

    public String getM1PomUrl() {
        return this.getPomUrl();
    }

    public void setM1PomUrl(String pomUrl) {
        this.setPomUrl(pomUrl);
    }
}

