/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.LinkedList;
import java.util.List;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.maven.continuum.web.model.BuildDefinitionSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildDefinitionAction
extends ContinuumConfirmAction {
    protected BuildDefinitionSummary generateBuildDefinitionSummary(BuildDefinition buildDefinition) {
        BuildDefinitionSummary bds = new BuildDefinitionSummary();
        bds.setGoals(buildDefinition.getGoals());
        bds.setId(buildDefinition.getId());
        bds.setArguments(buildDefinition.getArguments());
        bds.setBuildFile(buildDefinition.getBuildFile());
        bds.setScheduleId(buildDefinition.getSchedule().getId());
        bds.setScheduleName(buildDefinition.getSchedule().getName());
        bds.setIsDefault(buildDefinition.isDefaultForProject());
        bds.setIsBuildFresh(buildDefinition.isBuildFresh());
        if (buildDefinition.getProfile() != null) {
            bds.setProfileName(buildDefinition.getProfile().getName());
            bds.setProfileId(buildDefinition.getProfile().getId());
        }
        bds.setDescription(buildDefinition.getDescription());
        bds.setType(buildDefinition.getType());
        bds.setAlwaysBuild(buildDefinition.isBuildFresh() || buildDefinition.isAlwaysBuild());
        return bds;
    }

    protected List<BuildDefinitionSummary> generateBuildDefinitionSummaries(List<BuildDefinition> buildDefinitions) {
        LinkedList<BuildDefinitionSummary> buildDefinitionSummaries = new LinkedList<BuildDefinitionSummary>();
        for (BuildDefinition buildDefinition : buildDefinitions) {
            buildDefinitionSummaries.add(this.generateBuildDefinitionSummary(buildDefinition));
        }
        return buildDefinitionSummaries;
    }
}

