/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditLog {
    private Logger logger = LoggerFactory.getLogger((String)AuditLog.class.getName());
    private String action;
    private String category;
    private String resource;
    private String currentUser;

    public AuditLog(String action) {
        this.action = action;
    }

    public AuditLog(String resource, String action) {
        this.action = action;
        this.resource = resource;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void log() {
        if (this.currentUser != null) {
            MDC.put((String)"security.currentUser", (String)this.currentUser);
        }
        if (this.resource != null) {
            if (this.category != null) {
                this.logger.info(this.category + " " + this.resource + " - " + this.action);
            } else {
                this.logger.info(this.resource + " - " + this.action);
            }
        }
    }
}

