/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.continuum.configuration.BuildAgentConfiguration;
import org.apache.continuum.configuration.BuildAgentGroupConfiguration;
import org.apache.continuum.web.util.AuditLog;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAgentAction
extends ContinuumConfirmAction
implements SecureAction {
    private static final Logger logger = LoggerFactory.getLogger(BuildAgentAction.class);
    private List<BuildAgentConfiguration> buildAgents;
    private BuildAgentConfiguration buildAgent;
    private BuildAgentGroupConfiguration buildAgentGroup;
    private List<BuildAgentGroupConfiguration> buildAgentGroups;
    private List<BuildAgentConfiguration> selectedbuildAgents;
    private List<String> selectedBuildAgentIds;
    private List<Installation> installations;
    private boolean confirmed;
    private String message;
    private String type;
    private String typeGroup;

    public void prepare() throws Exception {
        super.prepare();
        this.setBuildAgents(this.getContinuum().getConfiguration().getBuildAgents());
    }

    public String input() throws Exception {
        if (this.buildAgent != null && !StringUtils.isBlank((String)this.buildAgent.getUrl())) {
            List agents = this.getContinuum().getConfiguration().getBuildAgents();
            for (BuildAgentConfiguration agent : agents) {
                if (!agent.getUrl().equals(this.buildAgent.getUrl())) continue;
                this.buildAgent = agent;
                this.type = "edit";
            }
        } else {
            this.type = "new";
        }
        return "input";
    }

    public String list() throws Exception {
        String errorMessage = ServletActionContext.getRequest().getParameter("errorMessage");
        if (errorMessage != null) {
            this.addActionError(errorMessage);
        }
        this.buildAgents = this.getContinuum().getConfiguration().getBuildAgents();
        this.buildAgentGroups = this.getContinuum().getConfiguration().getBuildAgentGroups();
        return "success";
    }

    public String view() throws Exception {
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
            if (!agent.getUrl().equals(this.buildAgent.getUrl())) continue;
            this.buildAgent = agent;
            try {
                this.installations = this.getContinuum().getDistributedBuildManager().getAvailableInstallations(this.buildAgent.getUrl());
            }
            catch (ContinuumException e) {
                logger.error("Unable to retrieve installations of build agent '" + agent.getUrl() + "'", (Throwable)e);
            }
            break;
        }
        return "success";
    }

    public String save() throws Exception {
        boolean found = false;
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        if (configuration.getBuildAgents() != null) {
            for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
                if (!this.buildAgent.getUrl().equals(agent.getUrl())) continue;
                agent.setDescription(this.buildAgent.getDescription());
                agent.setEnabled(this.buildAgent.isEnabled());
                configuration.updateBuildAgent(agent);
                found = true;
            }
        }
        AuditLog event = new AuditLog("Build Agent URL=" + this.buildAgent.getUrl(), "Modified Build Agent");
        event.setCategory("BUILD_AGENT");
        event.setCurrentUser(this.getPrincipal());
        if (!found) {
            configuration.addBuildAgent(this.buildAgent);
            event.setAction("Added Build Agent");
        } else if (this.type.equals("new")) {
            this.addActionError(this.getResourceBundle().getString("buildAgent.error.duplicate"));
            return "input";
        }
        this.getContinuum().getDistributedBuildManager().reload();
        event.log();
        return "success";
    }

    public String delete() throws Exception {
        if (!this.confirmed) {
            return "confirm";
        }
        if (this.getContinuum().getDistributedBuildManager().isBuildAgentBusy(this.buildAgent.getUrl())) {
            this.message = this.getText("buildAgent.error.delete.busy");
            return "error";
        }
        this.getContinuum().getDistributedBuildManager().removeDistributedBuildQueueOfAgent(this.buildAgent.getUrl());
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        if (configuration.getBuildAgentGroups() != null) {
            for (BuildAgentGroupConfiguration buildAgentGroup : configuration.getBuildAgentGroups()) {
                if (!configuration.containsBuildAgentUrl(this.buildAgent.getUrl(), buildAgentGroup)) continue;
                this.message = this.getText("buildAgent.error.remove.in.use");
                return "error";
            }
        }
        if (configuration.getBuildAgents() != null) {
            for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
                if (!this.buildAgent.getUrl().equals(agent.getUrl())) continue;
                configuration.removeBuildAgent(agent);
                AuditLog event = new AuditLog("Build Agent URL=" + agent.getUrl(), "Removed Build Agent");
                event.setCategory("BUILD_AGENT");
                event.setCurrentUser(this.getPrincipal());
                event.log();
                return "success";
            }
        }
        this.message = this.getText("buildAgent.error.notfound");
        return "error";
    }

    public String deleteGroup() throws Exception {
        if (!this.confirmed) {
            return "confirm";
        }
        List profiles = this.getContinuum().getProfileService().getAllProfiles();
        for (Profile profile : profiles) {
            if (!this.buildAgentGroup.getName().equals(profile.getBuildAgentGroup())) continue;
            this.message = this.getText("buildAgentGroup.error.remove.in.use");
            return "error";
        }
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        for (BuildAgentGroupConfiguration group : configuration.getBuildAgentGroups()) {
            if (!this.buildAgentGroup.getName().equals(group.getName())) continue;
            configuration.removeBuildAgentGroup(group);
            AuditLog event = new AuditLog("Build Agent Group=" + group.getName(), "Removed Build Agent Group");
            event.setCategory("BUILD_AGENT");
            event.setCurrentUser(this.getPrincipal());
            event.log();
            return "success";
        }
        this.message = this.getText("buildAgentGroup.error.doesnotexist");
        return "error";
    }

    public String saveGroup() throws Exception {
        boolean found = false;
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        this.selectedbuildAgents = this.getBuildAgentsFromSelectedBuildAgents();
        if (this.buildAgentGroup.getName() != null) {
            if (this.buildAgentGroup.getName().equals("")) {
                this.addActionError(this.getResourceBundle().getString("buildAgentGroup.error.name.required"));
                return "input";
            }
            if (this.buildAgentGroup.getName().trim().equals("")) {
                this.addActionError(this.getText("buildAgentGroup.error.name.cannot.be.spaces"));
                return "input";
            }
        }
        if (configuration.getBuildAgentGroups() != null) {
            for (BuildAgentGroupConfiguration group : configuration.getBuildAgentGroups()) {
                if (!this.buildAgentGroup.getName().equals(group.getName())) continue;
                group.setName(this.buildAgentGroup.getName());
                configuration.updateBuildAgentGroup(group);
                found = true;
                break;
            }
        }
        AuditLog event = new AuditLog("Build Agent Group=" + this.buildAgentGroup.getName(), "Modified Build Agent Group");
        event.setCategory("BUILD_AGENT");
        event.setCurrentUser(this.getPrincipal());
        if (!found) {
            this.buildAgentGroup.setBuildAgents(this.selectedbuildAgents);
            configuration.addBuildAgentGroup(this.buildAgentGroup);
            event.setAction("Added Build Agent Group");
        } else {
            if (this.typeGroup.equals("new")) {
                this.addActionError(this.getResourceBundle().getString("buildAgentGroup.error.duplicate"));
                return "input";
            }
            if (this.typeGroup.equals("edit")) {
                this.buildAgentGroup.setBuildAgents(this.selectedbuildAgents);
                configuration.updateBuildAgentGroup(this.buildAgentGroup);
            }
        }
        this.getContinuum().getDistributedBuildManager().reload();
        event.log();
        return "success";
    }

    public String inputGroup() throws Exception {
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        if (this.buildAgentGroup != null && !StringUtils.isBlank((String)this.buildAgentGroup.getName())) {
            List agentGroups = configuration.getBuildAgentGroups();
            for (BuildAgentGroupConfiguration group : agentGroups) {
                if (!this.buildAgentGroup.getName().equals(group.getName())) continue;
                this.buildAgentGroup = group;
                this.typeGroup = "edit";
                this.buildAgentGroup = configuration.getBuildAgentGroup(this.buildAgentGroup.getName());
                this.buildAgents = configuration.getBuildAgents();
                this.selectedBuildAgentIds = new ArrayList();
                if (this.buildAgentGroup.getBuildAgents() != null) {
                    for (BuildAgentConfiguration buildAgentConfiguration : this.buildAgentGroup.getBuildAgents()) {
                        this.selectedBuildAgentIds.add(buildAgentConfiguration.getUrl());
                    }
                }
                ArrayList<BuildAgentConfiguration> unusedBuildAgents = new ArrayList<BuildAgentConfiguration>();
                for (BuildAgentConfiguration agent : this.getBuildAgents()) {
                    if (this.selectedBuildAgentIds.contains(agent.getUrl())) continue;
                    unusedBuildAgents.add(agent);
                }
                this.setBuildAgents(unusedBuildAgents);
                break;
            }
        } else {
            this.typeGroup = "new";
        }
        return "input";
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-distributed-builds", "*");
        return bundle;
    }

    private List<BuildAgentConfiguration> getBuildAgentsFromSelectedBuildAgents() {
        if (this.selectedBuildAgentIds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BuildAgentConfiguration> selectedbuildAgents = new ArrayList<BuildAgentConfiguration>();
        for (String ids : this.selectedBuildAgentIds) {
            BuildAgentConfiguration buildAgent = this.getContinuum().getConfiguration().getBuildAgent(ids);
            if (buildAgent == null) continue;
            selectedbuildAgents.add(buildAgent);
        }
        return selectedbuildAgents;
    }

    public List<BuildAgentConfiguration> getBuildAgents() {
        return this.buildAgents;
    }

    public void setBuildAgents(List<BuildAgentConfiguration> buildAgents) {
        this.buildAgents = buildAgents;
    }

    public BuildAgentConfiguration getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgentConfiguration buildAgent) {
        this.buildAgent = buildAgent;
    }

    public List<Installation> getInstallations() {
        return this.installations;
    }

    public void setInstallations(List<Installation> installations) {
        this.installations = installations;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<BuildAgentGroupConfiguration> getBuildAgentGroups() {
        return this.buildAgentGroups;
    }

    public void setBuildAgentGroups(List<BuildAgentGroupConfiguration> buildAgentGroups) {
        this.buildAgentGroups = buildAgentGroups;
    }

    public BuildAgentGroupConfiguration getBuildAgentGroup() {
        return this.buildAgentGroup;
    }

    public void setBuildAgentGroup(BuildAgentGroupConfiguration buildAgentGroup) {
        this.buildAgentGroup = buildAgentGroup;
    }

    public String getTypeGroup() {
        return this.typeGroup;
    }

    public void setTypeGroup(String typeGroup) {
        this.typeGroup = typeGroup;
    }

    public List<BuildAgentConfiguration> getSelectedbuildAgents() {
        return this.selectedbuildAgents;
    }

    public void setSelectedbuildAgents(List<BuildAgentConfiguration> selectedbuildAgents) {
        this.selectedbuildAgents = selectedbuildAgents;
    }

    public List<String> getSelectedBuildAgentIds() {
        return this.selectedBuildAgentIds == null ? Collections.EMPTY_LIST : this.selectedBuildAgentIds;
    }

    public void setSelectedBuildAgentIds(List<String> selectedBuildAgentIds) {
        this.selectedBuildAgentIds = selectedBuildAgentIds;
    }
}

