/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.continuum.release.distributed.DistributedReleaseUtil;
import org.apache.continuum.release.distributed.manager.DistributedReleaseManager;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.model.DistributedReleaseSummary;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedReleasesAction
extends ContinuumActionSupport
implements SecureAction {
    private List<DistributedReleaseSummary> releasesSummary;

    public String list() throws Exception {
        DistributedReleaseManager releaseManager = this.getContinuum().getDistributedReleaseManager();
        List releases = releaseManager.getAllReleasesInProgress();
        this.releasesSummary = new ArrayList();
        for (Map release : releases) {
            DistributedReleaseSummary summary = new DistributedReleaseSummary();
            summary.setReleaseId(DistributedReleaseUtil.getReleaseId((Map)release));
            summary.setReleaseGoal(DistributedReleaseUtil.getReleaseGoal((Map)release));
            summary.setBuildAgentUrl(DistributedReleaseUtil.getBuildAgentUrl((Map)release));
            summary.setProjectId(DistributedReleaseUtil.getProjectId((Map)release));
            this.releasesSummary.add(summary);
        }
        return "success";
    }

    public List<DistributedReleaseSummary> getReleasesSummary() {
        return this.releasesSummary;
    }

    public void setReleasesSummary(List<DistributedReleaseSummary> releasesSummary) {
        this.releasesSummary = releasesSummary;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-view-release", "*");
        return bundle;
    }
}

