/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractReleaseAction
extends ContinuumActionSupport {
    protected Map<String, String> getEnvironments(Profile profile) {
        Installation builder;
        if (profile == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> envVars = new HashMap<String, String>();
        String javaHome = this.getJavaHomeValue(profile);
        if (!StringUtils.isEmpty((String)javaHome)) {
            envVars.put(this.getContinuum().getInstallationService().getEnvVar("jdk"), javaHome);
        }
        if ((builder = profile.getBuilder()) != null) {
            envVars.put(this.getContinuum().getInstallationService().getEnvVar("maven2"), builder.getVarValue());
        }
        List installations = profile.getEnvironmentVariables();
        for (Installation installation : installations) {
            envVars.put(installation.getVarName(), installation.getVarValue());
        }
        return envVars;
    }

    private String getJavaHomeValue(Profile profile) {
        Installation jdk = profile.getJdk();
        if (jdk == null) {
            return null;
        }
        return jdk.getVarValue();
    }
}

