/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.view.jsp.ui;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.jsp.JspException;
import org.apache.struts2.views.jsp.ui.TextareaTag;

public class DateTag
extends TextareaTag {
    public static final String DATETAG_PROPERTY = "webwork.date";
    public static final String DATETAG_PROPERTY_PAST = "webwork.date.format.past";
    public static final String DATETAG_DEFAULT_PAST = "{0} ago";
    public static final String DATETAG_PROPERTY_FUTURE = "webwork.date.format.future";
    public static final String DATETAG_DEFAULT_FUTURE = "in {0}";
    public static final String DATETAG_PROPERTY_SECONDS = "webwork.date.format.seconds";
    public static final String DATETAG_DEFAULT_SECONDS = "an instant";
    public static final String DATETAG_PROPERTY_MINUTES = "webwork.date.format.minutes";
    public static final String DATETAG_DEFAULT_MINUTES = "{0,choice,1#one minute|1<{0} minutes}";
    public static final String DATETAG_PROPERTY_HOURS = "webwork.date.format.hours";
    public static final String DATETAG_DEFAULT_HOURS = "{0,choice,1#one hour|1<{0} hours}{1,choice,0#|1#, one minute|1<, {1} minutes}";
    public static final String DATETAG_PROPERTY_DAYS = "webwork.date.format.days";
    public static final String DATETAG_DEFAULT_DAYS = "{0,choice,1#one day|1<{0} days}{1,choice,0#|1#, one hour|1<, {1} hours}";
    public static final String DATETAG_PROPERTY_YEARS = "webwork.date.format.years";
    public static final String DATETAG_DEFAULT_YEARS = "{0,choice,1#one year|1<{0} years}{1,choice,0#|1#, one day|1<, {1} days}";
    private String format;
    private String actualName;
    private String nameAttr;
    private boolean nice;
    private Date date;
    private TextProvider tp;

    public int doEndTag() throws JspException {
        this.actualName = this.findString(this.nameAttr);
        String msg = null;
        ValueStack stack = this.getStack();
        Object dateObj = stack.findValue(this.actualName);
        if (dateObj != null) {
            if (dateObj instanceof Date) {
                this.date = (Date)dateObj;
            } else if (dateObj instanceof Long) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis((Long)dateObj);
                this.date = cal.getTime();
            } else {
                throw new JspException("Could not cast the requested object " + this.nameAttr + " to a java.util.Date");
            }
        }
        if (this.date != null && this.date.getTime() > 0L) {
            this.tp = this.findProviderInStack();
            if (this.tp == null) {
                throw new JspException("Could not find a TextProvider on the stack.");
            }
            if (this.nice) {
                msg = this.formatTime(this.date);
            } else if (this.format == null) {
                String globalFormat = null;
                globalFormat = this.tp.getText(DATETAG_PROPERTY);
                if (globalFormat != null) {
                    msg = new SimpleDateFormat(globalFormat, ActionContext.getContext().getLocale()).format(this.date);
                }
            } else {
                msg = new SimpleDateFormat(this.format, ActionContext.getContext().getLocale()).format(this.date);
            }
        }
        if (msg != null) {
            try {
                if (this.getId() == null) {
                    this.pageContext.getOut().write(msg);
                } else {
                    stack.getContext().put(this.getId(), msg);
                }
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        return 6;
    }

    private TextProvider findProviderInStack() {
        for (Object o : this.getStack().getRoot()) {
            if (!(o instanceof TextProvider)) continue;
            return (TextProvider)o;
        }
        return null;
    }

    public String formatTime(Date date) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        long secs = (new Date().getTime() - date.getTime()) / 1000L;
        long mins = secs / 60L;
        int min = (int)mins % 60;
        long hours = mins / 60L;
        int hour = (int)hours % 24;
        int days = (int)hours / 24;
        int day = days % 365;
        int years = days / 365;
        if (Math.abs(secs) < 60L) {
            args.add(new Long(secs));
            args.add(sb);
            args.add(null);
            sb.append(this.tp.getText(DATETAG_PROPERTY_SECONDS, DATETAG_DEFAULT_SECONDS, args));
        } else if (hours == 0L) {
            args.add(new Long(min));
            args.add(sb);
            args.add(null);
            sb.append(this.tp.getText(DATETAG_PROPERTY_MINUTES, DATETAG_DEFAULT_MINUTES, args));
        } else if (days == 0) {
            args.add(new Long(hour));
            args.add(new Long(min));
            args.add(sb);
            args.add(null);
            sb.append(this.tp.getText(DATETAG_PROPERTY_HOURS, DATETAG_DEFAULT_HOURS, args));
        } else if (years == 0) {
            args.add(new Long(days));
            args.add(new Long(hour));
            args.add(sb);
            args.add(null);
            sb.append(this.tp.getText(DATETAG_PROPERTY_DAYS, DATETAG_DEFAULT_DAYS, args));
        } else {
            args.add(new Object[]{new Long(years)});
            args.add(new Object[]{new Long(day)});
            args.add(sb);
            args.add(null);
            sb.append(this.tp.getText(DATETAG_PROPERTY_YEARS, DATETAG_DEFAULT_YEARS, args));
        }
        args.clear();
        args.add(sb.toString());
        if (date.before(new Date())) {
            return this.tp.getText(DATETAG_PROPERTY_PAST, DATETAG_DEFAULT_PAST, args);
        }
        return this.tp.getText(DATETAG_PROPERTY_FUTURE, DATETAG_DEFAULT_FUTURE, args);
    }

    public int doStartTag() throws JspException {
        return super.doStartTag();
    }

    public void setName(String name) {
        this.nameAttr = name;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isNice() {
        return this.nice;
    }

    public void setNice(boolean nice) {
        this.nice = nice;
    }
}

