/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.appareance;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import org.apache.continuum.web.appearance.ContinuumAppearance;
import org.apache.continuum.web.appearance.io.xpp3.ContinuumAppearanceModelsXpp3Reader;
import org.apache.continuum.web.appearance.io.xpp3.ContinuumAppearanceModelsXpp3Writer;
import org.apache.maven.continuum.web.appareance.AppareanceConfiguration;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAppareanceConfiguration
implements AppareanceConfiguration,
Initializable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String footer;
    public static final String APPEARANCE_FILE_NAME = "continuum-appearance.xml";
    private ContinuumAppearance continuumAppearance = new ContinuumAppearance();

    public void initialize() throws InitializationException {
        File appearanceConfFile = this.getAppearanceConfigurationFile();
        if (appearanceConfFile.exists()) {
            try {
                ContinuumAppearanceModelsXpp3Reader appearanceReader = new ContinuumAppearanceModelsXpp3Reader();
                this.continuumAppearance = appearanceReader.read((Reader)ReaderFactory.newXmlReader((File)appearanceConfFile));
                if (this.continuumAppearance != null) {
                    this.footer = this.continuumAppearance.getFooter();
                }
            }
            catch (IOException e) {
                this.log.warn("skip IOException reading appearance file continuum-appearance.xml, msg " + e.getMessage());
            }
            catch (XmlPullParserException e) {
                this.log.warn("skip XmlPullParserException reading appearance file continuum-appearance.xml, msg " + e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)this.footer)) {
            this.footer = this.getDefaultFooter();
        }
    }

    public String getFooter() {
        return this.footer;
    }

    public void saveFooter(String footerHtmlContent) throws IOException {
        this.continuumAppearance.setFooter(footerHtmlContent);
        ContinuumAppearanceModelsXpp3Writer writer = new ContinuumAppearanceModelsXpp3Writer();
        File confFile = this.getAppearanceConfigurationFile();
        if (!confFile.exists()) {
            confFile.getParentFile().mkdirs();
        }
        writer.write((Writer)new FileWriter(confFile), this.continuumAppearance);
        this.footer = footerHtmlContent;
    }

    private String getDefaultFooter() {
        int inceptionYear = 2005;
        int currentYear = Calendar.getInstance().get(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"xright\">");
        stringBuilder.append("Copyright &copy; ");
        stringBuilder.append(String.valueOf(inceptionYear) + "-" + String.valueOf(currentYear));
        stringBuilder.append("&nbsp;The Apache Software Foundation");
        stringBuilder.append("</div> <div class=\"clear\"><hr/></div>");
        return stringBuilder.toString();
    }

    private File getAppearanceConfigurationFile() {
        return new File(System.getProperty("appserver.base") + File.separator + "conf" + File.separator + APPEARANCE_FILE_NAME);
    }
}

