/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.notifier;

import java.util.Map;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

public abstract class AbstractNotifierEditActionSupport
extends ContinuumActionSupport {
    private int notifierId;
    private String notifierType;
    private boolean sendOnSuccess;
    private boolean sendOnFailure;
    private boolean sendOnError;
    private boolean sendOnWarning;
    private boolean sendOnScmFailure;
    private boolean fromGroupPage = false;

    protected abstract ProjectNotifier getNotifier() throws ContinuumException;

    protected abstract void saveNotifier(ProjectNotifier var1) throws ContinuumException;

    public String save() throws ContinuumException {
        boolean isNew;
        try {
            this.checkAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        ProjectNotifier notifier = this.getNotifier();
        boolean bl = isNew = notifier == null || this.getNotifierId() == 0;
        if (isNew) {
            notifier = new ProjectNotifier();
        }
        notifier.setType(this.getNotifierType());
        notifier.setSendOnSuccess(this.isSendOnSuccess());
        notifier.setSendOnFailure(this.isSendOnFailure());
        notifier.setSendOnError(this.isSendOnError());
        notifier.setSendOnWarning(this.isSendOnWarning());
        notifier.setSendOnScmFailure(this.isSendOnScmFailure());
        this.setNotifierConfiguration(notifier);
        this.saveNotifier(notifier);
        if (this.fromGroupPage) {
            return "to_group_page";
        }
        return "success";
    }

    public String edit() throws ContinuumException {
        ProjectNotifier notifier = this.getNotifier();
        if (notifier == null) {
            notifier = new ProjectNotifier();
        }
        try {
            this.checkAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.setNotifierType(notifier.getType());
        this.setSendOnSuccess(notifier.isSendOnSuccess());
        this.setSendOnFailure(notifier.isSendOnFailure());
        this.setSendOnError(notifier.isSendOnError());
        this.setSendOnWarning(notifier.isSendOnWarning());
        this.setSendOnScmFailure(notifier.isSendOnScmFailure());
        this.initConfiguration(notifier.getConfiguration());
        return "success";
    }

    public int getNotifierId() {
        return this.notifierId;
    }

    public String getNotifierType() {
        return this.notifierType;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public boolean isSendOnSuccess() {
        return this.sendOnSuccess;
    }

    public void setSendOnSuccess(boolean sendOnSuccess) {
        this.sendOnSuccess = sendOnSuccess;
    }

    public boolean isSendOnFailure() {
        return this.sendOnFailure;
    }

    public void setSendOnFailure(boolean sendOnFailure) {
        this.sendOnFailure = sendOnFailure;
    }

    public boolean isSendOnError() {
        return this.sendOnError;
    }

    public void setSendOnError(boolean sendOnError) {
        this.sendOnError = sendOnError;
    }

    public boolean isSendOnWarning() {
        return this.sendOnWarning;
    }

    public void setSendOnWarning(boolean sendOnWarning) {
        this.sendOnWarning = sendOnWarning;
    }

    public boolean isSendOnScmFailure() {
        return this.sendOnScmFailure;
    }

    public void setSendOnScmFailure(boolean sendOnScmFailure) {
        this.sendOnScmFailure = sendOnScmFailure;
    }

    public void setNotifierId(int notifierId) {
        this.notifierId = notifierId;
    }

    public boolean isFromGroupPage() {
        return this.fromGroupPage;
    }

    public void setFromGroupPage(boolean fromGroupPage) {
        this.fromGroupPage = fromGroupPage;
    }

    protected abstract void initConfiguration(Map var1);

    protected abstract void setNotifierConfiguration(ProjectNotifier var1);

    protected abstract void checkAuthorization() throws AuthorizationRequiredException, ContinuumException;
}

