/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.continuum.builder.distributed.manager.DistributedBuildManager;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.continuum.taskqueue.BuildProjectTask;
import org.apache.continuum.taskqueue.CheckOutTask;
import org.apache.continuum.taskqueue.PrepareBuildProjectsTask;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthenticationRequiredException;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.DistributedBuildSummary;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuesAction
extends ContinuumActionSupport
implements SecureAction,
LogEnabled {
    private static final String DISTRIBUTED_BUILD_SUCCESS = "distributed-build-success";
    private List<String> selectedBuildTaskHashCodes;
    private List<String> selectedCheckOutTaskHashCodes;
    private int buildDefinitionId;
    private int projectId;
    private int trigger;
    private String projectName;
    private Map<String, BuildProjectTask> currentBuildProjectTasks = new HashMap();
    private Map<String, CheckOutTask> currentCheckoutTasks = new HashMap();
    private Map<String, List<BuildProjectTask>> buildsInQueue = new HashMap();
    private Map<String, List<CheckOutTask>> checkoutsInQueue = new HashMap();
    DistributedBuildManager distributedBuildManager;
    private List<DistributedBuildSummary> distributedBuildSummary;
    private List<PrepareBuildProjectsTask> distributedBuildQueues;
    private String buildAgentUrl;
    private int projectGroupId;
    private String scmRootAddress;
    private List<String> selectedDistributedBuildTaskHashCodes;

    public String cancelCurrent() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.getContinuum().getBuildsManager().cancelBuild(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String removeCheckout() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.getContinuum().getBuildsManager().removeProjectFromCheckoutQueue(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String cancelCurrentCheckout() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        try {
            this.cancelCheckout(this.projectId);
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String display() throws Exception {
        Set keySet;
        if (this.getContinuum().getConfiguration().isDistributedBuildEnabled()) {
            this.distributedBuildSummary = new ArrayList();
            Map map = this.distributedBuildManager.getDistributedBuildProjects();
            for (String url : map.keySet()) {
                PrepareBuildProjectsTask task = (PrepareBuildProjectsTask)map.get(url);
                ProjectGroup projectGroup = this.getContinuum().getProjectGroup(task.getProjectGroupId());
                DistributedBuildSummary summary = new DistributedBuildSummary();
                summary.setUrl(url);
                summary.setProjectGroupId(task.getProjectGroupId());
                summary.setProjectGroupName(projectGroup.getName());
                summary.setScmRootAddress(task.getScmRootAddress());
                ProjectScmRoot scmRoot = this.getContinuum().getProjectScmRootByProjectGroupAndScmRootAddress(task.getProjectGroupId(), task.getScmRootAddress());
                if (scmRoot.getState() == 8) {
                    summary.setCancelEnabled(false);
                } else {
                    summary.setCancelEnabled(true);
                }
                this.distributedBuildSummary.add(summary);
            }
            this.distributedBuildQueues = this.getContinuum().getTaskQueueManager().getDistributedBuildProjectsInQueue();
            return DISTRIBUTED_BUILD_SUCCESS;
        }
        try {
            Map currentBuilds = this.getContinuum().getBuildsManager().getCurrentBuilds();
            keySet = currentBuilds.keySet();
            for (String key : keySet) {
                BuildProjectTask buildTask = (BuildProjectTask)currentBuilds.get(key);
                this.currentBuildProjectTasks.put(key, buildTask);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map builds = this.getContinuum().getBuildsManager().getProjectsInBuildQueues();
            keySet = builds.keySet();
            for (String key : keySet) {
                ArrayList<BuildProjectTask> buildTasks = new ArrayList<BuildProjectTask>();
                for (Task task : (List)builds.get(key)) {
                    BuildProjectTask buildTask = (BuildProjectTask)task;
                    buildTasks.add(buildTask);
                }
                this.buildsInQueue.put(key, buildTasks);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map currentCheckouts = this.getContinuum().getBuildsManager().getCurrentCheckouts();
            keySet = currentCheckouts.keySet();
            for (String key : keySet) {
                CheckOutTask checkoutTask = (CheckOutTask)currentCheckouts.get(key);
                this.currentCheckoutTasks.put(key, checkoutTask);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        try {
            Map checkouts = this.getContinuum().getBuildsManager().getProjectsInCheckoutQueues();
            keySet = checkouts.keySet();
            for (String key : keySet) {
                ArrayList<CheckOutTask> checkoutTasks = new ArrayList<CheckOutTask>();
                for (Task task : (List)checkouts.get(key)) {
                    CheckOutTask checkoutTask = (CheckOutTask)task;
                    checkoutTasks.add(checkoutTask);
                }
                this.checkoutsInQueue.put(key, checkoutTasks);
            }
        }
        catch (BuildManagerException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String remove() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectFromBuildQueue(this.projectId, this.buildDefinitionId, this.trigger, this.projectName);
        Project project = this.getContinuum().getProject(this.projectId);
        project.setState(project.getOldState());
        this.getContinuum().updateProject(project);
        return "success";
    }

    public String removeBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectsFromBuildQueueWithHashcodes(this.listToIntArray(this.getSelectedBuildTaskHashCodes()));
        return "success";
    }

    public String removeCheckoutEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getBuildsManager().removeProjectsFromCheckoutQueueWithHashcodes(this.listToIntArray(this.getSelectedCheckOutTaskHashCodes()));
        return "success";
    }

    public String cancelDistributedBuild() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.distributedBuildManager.cancelDistributedBuild(this.buildAgentUrl, this.projectGroupId, this.scmRootAddress);
        return "success";
    }

    public String removeDistributedBuildEntry() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getTaskQueueManager().removeFromDistributedBuildQueue(this.projectGroupId, this.scmRootAddress);
        return "success";
    }

    public String removeDistributedBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().getTaskQueueManager().removeTasksFromDistributedBuildQueueWithHashCodes(this.listToIntArray(this.getSelectedDistributedBuildTaskHashCodes()));
        return "success";
    }

    private int[] listToIntArray(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return new int[0];
        }
        int[] array = new int[]{};
        for (String intString : strings) {
            array = ArrayUtils.add((int[])array, (int)Integer.parseInt(intString));
        }
        return array;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-view-queues", "*");
        return bundle;
    }

    private boolean cancelCheckout(int projectId) throws BuildManagerException {
        Map tasks = this.getContinuum().getBuildsManager().getCurrentCheckouts();
        if (tasks != null) {
            Set keySet = tasks.keySet();
            for (String key : keySet) {
                Task task = (Task)tasks.get(key);
                if (task == null || !(task instanceof CheckOutTask)) continue;
                if (((CheckOutTask)task).getProjectId() == projectId) {
                    this.getLogger().info("Cancelling checkout for project " + projectId);
                    return this.getContinuum().getBuildsManager().cancelCheckout(projectId);
                }
                this.getLogger().warn("Current task is not for the given projectId (" + projectId + "): " + ((CheckOutTask)task).getProjectId() + "; not cancelling checkout");
            }
        } else {
            this.getLogger().warn("No task running - not cancelling checkout");
        }
        return false;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<String> getSelectedBuildTaskHashCodes() {
        return this.selectedBuildTaskHashCodes;
    }

    public void setSelectedBuildTaskHashCodes(List<String> selectedBuildTaskHashCodes) {
        this.selectedBuildTaskHashCodes = selectedBuildTaskHashCodes;
    }

    public List<String> getSelectedCheckOutTaskHashCodes() {
        return this.selectedCheckOutTaskHashCodes;
    }

    public void setSelectedCheckOutTaskHashCodes(List<String> selectedCheckOutTaskHashCodes) {
        this.selectedCheckOutTaskHashCodes = selectedCheckOutTaskHashCodes;
    }

    public Map<String, BuildProjectTask> getCurrentBuildProjectTasks() {
        return this.currentBuildProjectTasks;
    }

    public void setCurrentBuildProjectTasks(Map<String, BuildProjectTask> currentBuildProjectTasks) {
        this.currentBuildProjectTasks = currentBuildProjectTasks;
    }

    public Map<String, CheckOutTask> getCurrentCheckoutTasks() {
        return this.currentCheckoutTasks;
    }

    public void setCurrentCheckoutTasks(Map<String, CheckOutTask> currentCheckoutTasks) {
        this.currentCheckoutTasks = currentCheckoutTasks;
    }

    public Map<String, List<BuildProjectTask>> getBuildsInQueue() {
        return this.buildsInQueue;
    }

    public void setBuildsInQueue(Map<String, List<BuildProjectTask>> buildsInQueue) {
        this.buildsInQueue = buildsInQueue;
    }

    public Map<String, List<CheckOutTask>> getCheckoutsInQueue() {
        return this.checkoutsInQueue;
    }

    public void setCheckoutsInQueue(Map<String, List<CheckOutTask>> checkoutsInQueue) {
        this.checkoutsInQueue = checkoutsInQueue;
    }

    public List<DistributedBuildSummary> getDistributedBuildSummary() {
        return this.distributedBuildSummary;
    }

    public void setDistributedBuildSummary(List<DistributedBuildSummary> distributedBuildSummary) {
        this.distributedBuildSummary = distributedBuildSummary;
    }

    public String getBuildAgentUrl() {
        return this.buildAgentUrl;
    }

    public void setBuildAgentUrl(String buildAgentUrl) {
        this.buildAgentUrl = buildAgentUrl;
    }

    public List<PrepareBuildProjectsTask> getDistributedBuildQueues() {
        return this.distributedBuildQueues;
    }

    public void setDistributedBuildQueues(List<PrepareBuildProjectsTask> distributedBuildQueues) {
        this.distributedBuildQueues = distributedBuildQueues;
    }

    public List<String> getSelectedDistributedBuildTaskHashCodes() {
        return this.selectedDistributedBuildTaskHashCodes;
    }

    public void setSelectedDistributedBuildTaskHashCodes(List<String> selectedDistributedBuildTaskHashCodes) {
        this.selectedDistributedBuildTaskHashCodes = selectedDistributedBuildTaskHashCodes;
    }
}

