/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.continuum.installation.InstallationService;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.profile.AlreadyExistsProfileException;
import org.apache.maven.continuum.profile.ProfileException;
import org.apache.maven.continuum.profile.ProfileService;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.struts2.ServletActionContext;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileAction
extends ContinuumActionSupport
implements Preparable,
SecureAction {
    private ProfileService profileService;
    private InstallationService installationService;
    private List<Profile> profiles;
    private Profile profile;
    private int installationId;
    private List<Installation> allInstallations;
    private List<Installation> profileInstallations;
    private String message;

    public String input() throws Exception {
        this.allInstallations = this.installationService.getAllInstallations();
        return "input";
    }

    public String list() throws Exception {
        String errorMessage = ServletActionContext.getRequest().getParameter("errorMessage");
        if (errorMessage != null) {
            this.addActionError(errorMessage);
        }
        this.profiles = this.profileService.getAllProfiles();
        return "success";
    }

    public String edit() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("edit profile with id " + this.profile.getId());
        }
        this.profile = this.profileService.getProfile(this.profile.getId());
        return "success";
    }

    public String save() throws Exception {
        try {
            Profile stored = this.profileService.getProfile(this.profile.getId());
            if (StringUtils.isBlank((String)this.profile.getName())) {
                if (stored != null) {
                    this.profile = stored;
                }
                this.addFieldError("profile.name", this.getResourceBundle().getString("profile.name.required"));
                return "input";
            }
            if (stored == null) {
                this.profile = this.profileService.addProfile(this.profile);
                this.allInstallations = this.installationService.getAllInstallations();
                return "editProfile";
            }
            String name = this.profile.getName();
            this.profile = this.profileService.getProfile(this.profile.getId());
            if (!StringUtils.equals((String)name, (String)this.profile.getName())) {
                this.profile.setName(name);
                this.profileService.updateProfile(this.profile);
            }
        }
        catch (AlreadyExistsProfileException e) {
            this.addActionError(this.getResourceBundle().getString("profile.name.already.exists"));
            return "input";
        }
        this.profiles = this.profileService.getAllProfiles();
        return "success";
    }

    public String delete() throws Exception {
        try {
            this.profileService.deleteProfile(this.profile.getId());
            this.profiles = this.profileService.getAllProfiles();
            return "success";
        }
        catch (ProfileException e) {
            this.message = "profile.remove.error";
            return "error";
        }
    }

    public String confirmDelete() throws ProfileException {
        this.profile = this.getContinuum().getProfileService().getProfile(this.profile.getId());
        return "success";
    }

    public String addInstallation() throws Exception {
        Installation installation = this.installationService.getInstallation(this.getInstallationId());
        if (installation != null) {
            this.profileService.addInstallationInProfile(this.profile, installation);
            this.profile = this.profileService.getProfile(this.profile.getId());
        }
        return "success";
    }

    public String removeInstallation() throws Exception {
        Installation installation = this.installationService.getInstallation(this.getInstallationId());
        this.profileService.removeInstallationFromProfile(this.profile, installation);
        this.profile = this.profileService.getProfile(this.profile.getId());
        return "success";
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-profiles", "*");
        return bundle;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public List<Installation> getAllInstallations() throws Exception {
        if (this.allInstallations == null) {
            this.allInstallations = this.installationService.getAllInstallations();
        }
        if (this.profile != null) {
            this.allInstallations.removeAll(this.profile.getEnvironmentVariables());
        }
        return this.allInstallations;
    }

    public void setAllInstallations(List<Installation> allInstallations) {
        this.allInstallations = allInstallations;
    }

    public List<Installation> getProfileInstallations() {
        if (this.profile != null) {
            if (this.profileInstallations == null) {
                this.profileInstallations = new ArrayList();
                if (this.profile.getJdk() != null) {
                    this.profileInstallations.add(this.profile.getJdk());
                }
                if (this.profile.getBuilder() != null) {
                    this.profileInstallations.add(this.profile.getBuilder());
                }
                if (this.profile.getEnvironmentVariables() != null && !this.profile.getEnvironmentVariables().isEmpty()) {
                    this.profileInstallations.addAll(this.profile.getEnvironmentVariables());
                }
            }
            return this.profileInstallations;
        }
        return Collections.EMPTY_LIST;
    }

    public void setProfileInstallations(List<Installation> profileInstallations) {
        this.profileInstallations = profileInstallations;
    }

    public int getInstallationId() {
        return this.installationId;
    }

    public void setInstallationId(int installationId) {
        this.installationId = installationId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

