/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork2.Preparable;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.continuum.configuration.ContinuumConfigurationException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.configuration.ConfigurationStoringException;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public class ConfigurationAction
extends ContinuumActionSupport
implements Preparable,
SecureAction {
    private String workingDirectory;
    private String buildOutputDirectory;
    private String deploymentRepositoryDirectory;
    private String baseUrl;
    private String releaseOutputDirectory;
    private int numberOfAllowedBuildsinParallel = 1;
    private boolean requireReleaseOutput;
    private boolean distributedBuildEnabled;

    public void prepare() {
        File releaseOutputDirectoryFile;
        File deploymentRepositoryDirectoryFile;
        File buildOutputDirectoryFile;
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        File workingDirectoryFile = configuration.getWorkingDirectory();
        if (workingDirectoryFile != null) {
            this.workingDirectory = workingDirectoryFile.getAbsolutePath();
        }
        if ((buildOutputDirectoryFile = configuration.getBuildOutputDirectory()) != null) {
            this.buildOutputDirectory = buildOutputDirectoryFile.getAbsolutePath();
        }
        if ((deploymentRepositoryDirectoryFile = configuration.getDeploymentRepositoryDirectory()) != null) {
            this.deploymentRepositoryDirectory = deploymentRepositoryDirectoryFile.getAbsolutePath();
        }
        this.baseUrl = configuration.getUrl();
        if (StringUtils.isEmpty((String)this.baseUrl)) {
            HttpServletRequest request = ServletActionContext.getRequest();
            this.baseUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            this.getLogger().info("baseUrl='" + this.baseUrl + "'");
        }
        if ((releaseOutputDirectoryFile = configuration.getReleaseOutputDirectory()) != null) {
            this.releaseOutputDirectory = releaseOutputDirectoryFile.getAbsolutePath();
        }
        this.numberOfAllowedBuildsinParallel = configuration.getNumberOfBuildsInParallel();
        if (this.numberOfAllowedBuildsinParallel == 0) {
            this.numberOfAllowedBuildsinParallel = 1;
        }
        String requireRelease = ServletActionContext.getRequest().getParameter("requireReleaseOutput");
        this.setRequireReleaseOutput(new Boolean(requireRelease).booleanValue());
        this.distributedBuildEnabled = configuration.isDistributedBuildEnabled();
    }

    public String input() {
        if (this.isRequireReleaseOutput()) {
            this.addActionError(this.getText("configuration.releaseOutputDirectory.required"));
        }
        if (this.numberOfAllowedBuildsinParallel <= 0) {
            this.addActionError("configuration.numberOfBuildsInParallel.invalid");
        }
        return "input";
    }

    public String save() throws ConfigurationStoringException, ContinuumStoreException, ContinuumConfigurationException {
        if (this.numberOfAllowedBuildsinParallel <= 0) {
            this.addActionError("Number of Allowed Builds in Parallel must be greater than zero.");
            return "error";
        }
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        configuration.setWorkingDirectory(new File(this.workingDirectory));
        configuration.setBuildOutputDirectory(new File(this.buildOutputDirectory));
        configuration.setNumberOfBuildsInParallel(this.numberOfAllowedBuildsinParallel);
        if (StringUtils.isNotEmpty((String)this.deploymentRepositoryDirectory)) {
            configuration.setDeploymentRepositoryDirectory(new File(this.deploymentRepositoryDirectory));
        } else {
            configuration.setDeploymentRepositoryDirectory(null);
        }
        configuration.setUrl(this.baseUrl);
        configuration.setInitialized(true);
        if (StringUtils.isNotEmpty((String)this.releaseOutputDirectory)) {
            configuration.setReleaseOutputDirectory(new File(this.releaseOutputDirectory));
        } else {
            if (this.isRequireReleaseOutput()) {
                this.addActionError(this.getText("configuration.releaseOutputDirectory.required"));
                return "error";
            }
            configuration.setReleaseOutputDirectory(null);
        }
        configuration.setDistributedBuildEnabled(this.distributedBuildEnabled);
        configuration.store();
        return "success";
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getDeploymentRepositoryDirectory() {
        return this.deploymentRepositoryDirectory;
    }

    public void setDeploymentRepositoryDirectory(String deploymentRepositoryDirectory) {
        this.deploymentRepositoryDirectory = deploymentRepositoryDirectory;
    }

    public String getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public void setBuildOutputDirectory(String buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-configuration", "*");
        return bundle;
    }

    public String getReleaseOutputDirectory() {
        return this.releaseOutputDirectory;
    }

    public void setReleaseOutputDirectory(String releaseOutputDirectory) {
        this.releaseOutputDirectory = releaseOutputDirectory;
    }

    public boolean isRequireReleaseOutput() {
        return this.requireReleaseOutput;
    }

    public void setRequireReleaseOutput(boolean requireReleaseOutput) {
        this.requireReleaseOutput = requireReleaseOutput;
    }

    public int getNumberOfAllowedBuildsinParallel() {
        return this.numberOfAllowedBuildsinParallel;
    }

    public void setNumberOfAllowedBuildsinParallel(int numberOfAllowedBuildsinParallel) {
        this.numberOfAllowedBuildsinParallel = numberOfAllowedBuildsinParallel;
    }

    public boolean isDistributedBuildEnabled() {
        return this.distributedBuildEnabled;
    }

    public void setDistributedBuildEnabled(boolean distributedBuildEnabled) {
        this.distributedBuildEnabled = distributedBuildEnabled;
    }
}

