/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildQueue;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueueAction
extends ContinuumActionSupport
implements Preparable {
    private String name;
    private int size;
    private List<BuildQueue> buildQueueList;
    private BuildQueue buildQueue;
    private String message;

    public void prepare() throws ContinuumException {
        this.buildQueueList = this.getContinuum().getAllBuildQueues();
    }

    public String input() {
        return "input";
    }

    public String list() throws Exception {
        try {
            this.buildQueueList = this.getContinuum().getAllBuildQueues();
        }
        catch (ContinuumException e) {
            this.addActionError("Cannot get build queues from the database : " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public String save() throws Exception {
        int allowedBuilds = this.getContinuum().getConfiguration().getNumberOfBuildsInParallel();
        if (allowedBuilds < this.buildQueueList.size() + 1) {
            this.addActionError("You are only allowed " + allowedBuilds + " number of builds in parallel.");
            return "error";
        }
        try {
            if (this.isDuplicate(this.name)) {
                this.addActionError("Build queue name already exists.");
                return "error";
            }
            BuildQueue buildQueue = new BuildQueue();
            buildQueue.setName(this.name);
            BuildQueue addedBuildQueue = this.getContinuum().addBuildQueue(buildQueue);
            this.getContinuum().getBuildsManager().addOverallBuildQueue(addedBuildQueue);
        }
        catch (ContinuumException e) {
            this.addActionError("Error adding build queue to database: " + e.getMessage());
            return "error";
        }
        catch (BuildManagerException e) {
            this.addActionError("Error creating overall build queue: " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public String edit() throws Exception {
        try {
            BuildQueue buildQueueToBeEdited = this.getContinuum().getBuildQueue(this.buildQueue.getId());
        }
        catch (ContinuumException e) {
            this.addActionError("Error retrieving build queue from the database : " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public String delete() throws Exception {
        BuildQueue buildQueueToBeDeleted = this.getContinuum().getBuildQueue(this.buildQueue.getId());
        this.getContinuum().getBuildsManager().removeOverallBuildQueue(buildQueueToBeDeleted.getId());
        this.getContinuum().removeBuildQueue(buildQueueToBeDeleted);
        this.buildQueueList = this.getContinuum().getAllBuildQueues();
        return "success";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BuildQueue> getBuildQueueList() {
        return this.buildQueueList;
    }

    public void setBuildQueueList(List<BuildQueue> buildQueueList) {
        this.buildQueueList = buildQueueList;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public BuildQueue getBuildQueue() {
        return this.buildQueue;
    }

    public void setBuildQueue(BuildQueue buildQueue) {
        this.buildQueue = buildQueue;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private boolean isDuplicate(String queueName) throws ContinuumException {
        boolean isExisting = false;
        List buildQueues = this.getContinuum().getAllBuildQueues();
        for (BuildQueue bq : buildQueues) {
            if (!queueName.equals(bq.getName())) continue;
            isExisting = true;
            break;
        }
        return isExisting;
    }
}

