/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.continuum.buildmanager.BuildManagerException;
import org.apache.continuum.buildmanager.BuildsManager;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.action.SummaryAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.GroupSummary;
import org.apache.maven.continuum.web.model.ProjectSummary;

public class SummaryAction
extends ContinuumActionSupport {
    private int projectGroupId;
    private String projectGroupName;
    private List summary;
    private GroupSummary groupSummary = new GroupSummary();
    private BuildsManager parallelBuildsManager;

    public String execute() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        Collection projectsInGroup = this.getContinuum().getProjectsInGroup(this.projectGroupId);
        Map buildResults = this.getContinuum().getLatestBuildResults(this.projectGroupId);
        Map buildResultsInSuccess = this.getContinuum().getBuildResultsInSuccess(this.projectGroupId);
        this.summary = new ArrayList();
        this.groupSummary.setNumErrors(0);
        this.groupSummary.setNumFailures(0);
        this.groupSummary.setNumSuccesses(0);
        this.groupSummary.setNumProjects(0);
        for (Project project : projectsInGroup) {
            BuildResult latestBuild;
            BuildResult buildInSuccess;
            this.groupSummary.setNumProjects(this.groupSummary.getNumProjects() + 1);
            ProjectSummary model = new ProjectSummary();
            model.setId(project.getId());
            model.setName(project.getName());
            model.setVersion(project.getVersion());
            model.setProjectGroupId(project.getProjectGroup().getId());
            model.setProjectGroupName(project.getProjectGroup().getName());
            model.setProjectType(project.getExecutorId());
            try {
                if (this.parallelBuildsManager.isInAnyBuildQueue(project.getId())) {
                    model.setInBuildingQueue(true);
                } else if (this.parallelBuildsManager.isInAnyCheckoutQueue(project.getId())) {
                    model.setInCheckoutQueue(true);
                } else {
                    model.setInBuildingQueue(false);
                    model.setInCheckoutQueue(false);
                }
            }
            catch (BuildManagerException e) {
                throw new ContinuumException(e.getMessage(), (Throwable)e);
            }
            model.setState(project.getState());
            model.setBuildNumber(project.getBuildNumber());
            if (buildResultsInSuccess != null && (buildInSuccess = (BuildResult)buildResultsInSuccess.get(new Integer(project.getId()))) != null) {
                model.setBuildInSuccessId(buildInSuccess.getId());
            }
            if (buildResults != null && (latestBuild = (BuildResult)buildResults.get(new Integer(project.getId()))) != null) {
                model.setLatestBuildId(latestBuild.getId());
                this.populateGroupSummary(latestBuild);
                model.setLastBuildDateTime(latestBuild.getEndTime());
                model.setLastBuildDuration(latestBuild.getDurationTime());
            }
            this.summary.add(model);
        }
        1 projectComparator = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(this.summary, projectComparator);
        return "success";
    }

    private void populateGroupSummary(BuildResult latestBuild) {
        switch (latestBuild.getState()) {
            case 4: {
                this.groupSummary.setNumErrors(this.groupSummary.getNumErrors() + 1);
                break;
            }
            case 2: {
                this.groupSummary.setNumSuccesses(this.groupSummary.getNumSuccesses() + 1);
                break;
            }
            case 3: {
                this.groupSummary.setNumFailures(this.groupSummary.getNumFailures() + 1);
                break;
            }
            default: {
                if (latestBuild.getState() != 5 && latestBuild.getState() <= 10) break;
                this.getLogger().warn("unknown buildState value " + latestBuild.getState() + " with build " + latestBuild.getId());
            }
        }
    }

    public List getProjects() {
        return this.summary;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public String getProjectGroupName() {
        return this.projectGroupName;
    }

    public void setProjectGroupName(String projectGroupName) {
        this.projectGroupName = projectGroupName;
    }

    public GroupSummary getGroupSummary() {
        return this.groupSummary;
    }

    public void setGroupSummary(GroupSummary groupSummary) {
        this.groupSummary = groupSummary;
    }
}

