/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.utils.WorkingDirectoryService;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class ReleaseRollbackAction
extends ContinuumActionSupport {
    private WorkingDirectoryService workingDirectoryService;
    private int projectId;
    private String releaseId;
    private String projectGroupName = "";
    private String releaseGoal;

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        DefaultReleaseManagerListener listener = new DefaultReleaseManagerListener();
        Project project = this.getContinuum().getProject(this.projectId);
        releaseManager.rollback(this.releaseId, this.workingDirectoryService.getWorkingDirectory(project).getPath(), (ContinuumReleaseManagerListener)listener);
        while (listener.getState() != 3) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        releaseManager.getPreparedReleases().remove(this.releaseId);
        return "success";
    }

    public String warn() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        return "success";
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public String getReleaseGoal() {
        return this.releaseGoal;
    }

    public void setReleaseGoal(String releaseGoal) {
        this.releaseGoal = releaseGoal;
    }
}

