/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleasePrepareAction
extends ContinuumActionSupport {
    private static final String SCM_SVN_PROTOCOL_PREFIX = "scm:svn";
    private static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    private int projectId;
    private String releaseId;
    private String name;
    private String scmUsername;
    private String scmPassword;
    private String scmTag;
    private String scmTagBase;
    private boolean scmUseEditMode = false;
    private List projects = new ArrayList();
    private List projectKeys;
    private List devVersions;
    private List relVersions;
    private String prepareGoals;
    private ReleaseResult result;
    private ContinuumReleaseManagerListener listener;
    private String projectGroupName = "";
    private List<Profile> profiles;
    private int profileId;

    public String input() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        Project project = this.getContinuum().getProject(this.projectId);
        this.scmUsername = project.getScmUsername();
        this.scmPassword = project.getScmPassword();
        this.scmTag = project.getScmTag();
        if (this.scmTag == null) {
            String version = project.getVersion();
            int idx = version.indexOf(SNAPSHOT_VERSION_SUFFIX);
            this.scmTag = idx >= 0 ? project.getArtifactId() + "-" + version.substring(0, idx) : project.getArtifactId() + "-" + version;
        }
        String workingDirectory = this.getContinuum().getWorkingDirectory(project.getId()).getPath();
        String scmUrl = project.getScmUrl();
        if (scmUrl.startsWith(SCM_SVN_PROTOCOL_PREFIX)) {
            this.scmTagBase = new SvnScmProviderRepository(scmUrl, this.scmUsername, this.scmPassword).getTagBase();
            this.scmTagBase = this.scmTagBase.substring(SCM_SVN_PROTOCOL_PREFIX.length() + 1);
        } else {
            this.scmTagBase = "";
        }
        this.prepareGoals = "clean integration-test";
        this.getReleasePluginParameters(workingDirectory, "pom.xml");
        this.processProject(workingDirectory, "pom.xml");
        this.profiles = this.getContinuum().getProfileService().getAllProfiles();
        return "success";
    }

    private void getReleasePluginParameters(String workingDirectory, String pomFilename) throws Exception {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)new FileReader(new File(workingDirectory, pomFilename)));
        if (model.getBuild() != null && model.getBuild().getPlugins() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                Xpp3Dom dom;
                if (plugin.getGroupId() == null || !plugin.getGroupId().equals("org.apache.maven.plugins") || plugin.getArtifactId() == null || !plugin.getArtifactId().equals("maven-release-plugin") || (dom = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
                Xpp3Dom configuration = dom.getChild("releaseLabel");
                if (configuration != null) {
                    this.scmTag = configuration.getValue();
                }
                if ((configuration = dom.getChild("tag")) != null) {
                    this.scmTag = configuration.getValue();
                }
                if ((configuration = dom.getChild("tagBase")) != null) {
                    this.scmTagBase = configuration.getValue();
                }
                if ((configuration = dom.getChild("preparationGoals")) == null) continue;
                this.prepareGoals = configuration.getValue();
            }
        }
    }

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.listener = new DefaultReleaseManagerListener();
        Project project = this.getContinuum().getProject(this.projectId);
        this.name = project.getName();
        if (this.name == null) {
            this.name = project.getArtifactId();
        }
        Profile profile = null;
        if (this.profileId != -1) {
            profile = this.getContinuum().getProfileService().getProfile(this.profileId);
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        this.releaseId = releaseManager.prepare(project, this.getReleaseProperties(), this.getRelVersionMap(), this.getDevVersionMap(), this.listener, profile);
        return "success";
    }

    public String viewResult() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.result = (ReleaseResult)this.getContinuum().getReleaseManager().getReleaseResults().get(this.releaseId);
        return "viewResult";
    }

    public String checkProgress() throws Exception {
        String status;
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        this.listener = (ContinuumReleaseManagerListener)releaseManager.getListeners().get(this.releaseId);
        if (this.listener != null) {
            if (this.listener.getState() == 3) {
                releaseManager.getListeners().remove(this.releaseId);
                this.result = (ReleaseResult)releaseManager.getReleaseResults().get(this.releaseId);
                status = "finished";
            } else {
                status = "inProgress";
            }
        } else {
            throw new Exception("There is no release on-going or finished with id: " + this.releaseId);
        }
        return status;
    }

    private void processProject(String workingDirectory, String pomFilename) throws Exception {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)new FileReader(new File(workingDirectory, pomFilename)));
        if (model.getGroupId() == null) {
            model.setGroupId(model.getParent().getGroupId());
        }
        if (model.getVersion() == null) {
            model.setVersion(model.getParent().getVersion());
        }
        this.setProperties(model);
        Iterator modules = model.getModules().iterator();
        while (modules.hasNext()) {
            this.processProject(workingDirectory + "/" + modules.next().toString(), "pom.xml");
        }
    }

    private void setProperties(Model model) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", model.getGroupId() + ":" + model.getArtifactId());
        if (model.getName() == null) {
            model.setName(model.getArtifactId());
        }
        params.put("name", model.getName());
        DefaultVersionInfo version = new DefaultVersionInfo(model.getVersion());
        params.put("release", version.getReleaseVersionString());
        params.put("dev", version.getNextVersion().getSnapshotVersionString());
        this.projects.add(params);
    }

    private Map getDevVersionMap() {
        return this.getVersionMap(this.projectKeys, this.devVersions);
    }

    private Map getRelVersionMap() {
        return this.getVersionMap(this.projectKeys, this.relVersions);
    }

    private Map getVersionMap(List keys, List versions) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        for (int idx = 0; idx < keys.size(); ++idx) {
            String key = keys.get(idx).toString();
            String version = versions.get(idx).toString();
            versionMap.put(key, version);
        }
        return versionMap;
    }

    private Properties getReleaseProperties() {
        Properties p = new Properties();
        if (StringUtils.isNotEmpty((String)this.scmUsername)) {
            p.setProperty("username", this.scmUsername);
        }
        if (StringUtils.isNotEmpty((String)this.scmPassword)) {
            p.setProperty("password", this.scmPassword);
        }
        if (StringUtils.isNotEmpty((String)this.scmTagBase)) {
            p.setProperty("tagBase", this.scmTagBase);
        }
        p.setProperty("tag", this.scmTag);
        p.setProperty("prepareGoals", this.prepareGoals);
        p.setProperty("useEditMode", Boolean.toString(this.scmUseEditMode));
        return p;
    }

    public List getProjectKeys() {
        return this.projectKeys;
    }

    public void setProjectKeys(List projectKeys) {
        this.projectKeys = projectKeys;
    }

    public List getDevVersions() {
        return this.devVersions;
    }

    public void setDevVersions(List devVersions) {
        this.devVersions = devVersions;
    }

    public List getRelVersions() {
        return this.relVersions;
    }

    public void setRelVersions(List relVersions) {
        this.relVersions = relVersions;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public List getProjects() {
        return this.projects;
    }

    public void setProjects(List projects) {
        this.projects = projects;
    }

    public ContinuumReleaseManagerListener getListener() {
        return this.listener;
    }

    public void setListener(DefaultReleaseManagerListener listener) {
        this.listener = listener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public String getPrepareGoals() {
        return this.prepareGoals;
    }

    public void setPrepareGoals(String prepareGoals) {
        this.prepareGoals = prepareGoals;
    }

    public void validate() {
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int profileId) {
        this.profileId = profileId;
    }

    public boolean isScmUseEditMode() {
        return this.scmUseEditMode;
    }

    public void setScmUseEditMode(boolean scmUseEditMode) {
        this.scmUseEditMode = scmUseEditMode;
    }
}

