/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

public class ReleaseCleanupAction
extends ContinuumActionSupport {
    private int projectId;
    private String releaseId;
    private String projectGroupName = "";

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        releaseManager.getReleaseResults().remove(this.releaseId);
        ContinuumReleaseManagerListener listener = (ContinuumReleaseManagerListener)releaseManager.getListeners().remove(this.releaseId);
        if (listener != null) {
            String goal = listener.getGoalName();
            return goal + "Finished";
        }
        throw new Exception("No listener to cleanup for id " + this.releaseId);
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public int getProjectGroupId() throws ContinuumException {
        return this.getContinuum().getProjectGroupByProjectId(this.projectId).getId();
    }
}

