/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsListAction
extends ContinuumActionSupport {
    private List<String> selectedProjects;
    private List<String> selectedProjectsNames;
    private String projectGroupName = "";
    private int projectGroupId;
    private String methodToCall;
    private int buildDefinitionId;

    public String execute() throws Exception {
        if (StringUtils.isEmpty((String)this.methodToCall)) {
            return "success";
        }
        if ("build".equals(this.methodToCall)) {
            return this.build();
        }
        if ("remove".equals(this.methodToCall)) {
            return this.remove();
        }
        if ("confirmRemove".equals(this.methodToCall)) {
            return this.confirmRemove();
        }
        return "success";
    }

    private String remove() throws ContinuumException {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.selectedProjects != null && !this.selectedProjects.isEmpty()) {
            for (String selectedProject : this.selectedProjects) {
                int projectId = Integer.parseInt(selectedProject);
                try {
                    this.getLogger().info("Removing Project with id=" + projectId);
                    this.getContinuum().removeProject(projectId);
                }
                catch (ContinuumException e) {
                    this.getLogger().error("Error removing Project with id=" + projectId);
                    this.addActionError(this.getText("Unable to remove Project with id=" + projectId));
                }
            }
        }
        return "success";
    }

    public String confirmRemove() throws ContinuumException {
        if (this.selectedProjects != null && !this.selectedProjects.isEmpty()) {
            this.selectedProjectsNames = new ArrayList();
            for (String selectedProject : this.selectedProjects) {
                int projectId = Integer.parseInt(selectedProject);
                this.selectedProjectsNames.add(this.getContinuum().getProject(projectId).getName());
            }
        }
        return "confirmRemove";
    }

    private String build() throws ContinuumException {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.selectedProjects != null && !this.selectedProjects.isEmpty()) {
            List<Object> sortedProjects;
            ArrayList<Project> projectsList = new ArrayList<Project>();
            Iterator i = this.selectedProjects.iterator();
            while (i.hasNext()) {
                int projectId = Integer.parseInt((String)i.next());
                Project p = this.getContinuum().getProjectWithAllDetails(projectId);
                projectsList.add(p);
            }
            try {
                sortedProjects = this.getContinuum().getProjectsInBuildOrder(projectsList);
            }
            catch (CycleDetectedException e) {
                sortedProjects = projectsList;
            }
            if (this.getBuildDefinitionId() <= 0) {
                List groupDefaultBDs = this.getContinuum().getDefaultBuildDefinitionsForProjectGroup(this.projectGroupId);
                this.getContinuum().buildProjectsWithBuildDefinition(sortedProjects, groupDefaultBDs);
            } else {
                this.getContinuum().buildProjectsWithBuildDefinition(sortedProjects, this.buildDefinitionId);
            }
        }
        return "success";
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroup(this.projectGroupId).getName();
        }
        return this.projectGroupName;
    }

    public List<String> getSelectedProjects() {
        return this.selectedProjects;
    }

    public void setSelectedProjects(List<String> selectedProjects) {
        this.selectedProjects = selectedProjects;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public List<String> getSelectedProjectsNames() {
        return this.selectedProjectsNames;
    }

    public void setSelectedProjectsNames(List<String> selectedProjectsNames) {
        this.selectedProjectsNames = selectedProjectsNames;
    }
}

