/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.Date;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

public class ProjectViewAction
extends ContinuumActionSupport {
    private Project project;
    private int projectId;
    private String lastBuildDateTime;
    private ProjectGroup projectGroup;

    public String execute() throws ContinuumException {
        this.projectGroup = this.getProjectGroup();
        try {
            this.checkViewProjectGroupAuthorization(this.projectGroup.getName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        if (this.project.getLatestBuildId() > 0) {
            try {
                BuildResult lastBuildResult = this.getContinuum().getBuildResult(this.project.getLatestBuildId());
                if (lastBuildResult != null) {
                    this.setLastBuildDateTime(this.dateFormatter.format(new Date(lastBuildResult.getEndTime())));
                }
            }
            catch (ContinuumException e) {
                this.getLogger().info("buildResult with id " + this.project.getLatestBuildId() + " has been deleted");
            }
        }
        return "success";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.project;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public ProjectGroup getProjectGroup() throws ContinuumException {
        return this.getContinuum().getProjectGroupByProjectId(this.projectId);
    }

    public String getLastBuildDateTime() {
        return this.lastBuildDateTime;
    }

    public void setLastBuildDateTime(String lastBuildDateTime) {
        this.lastBuildDateTime = lastBuildDateTime;
    }
}

