/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.model.GroupSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSummaryAction
extends ContinuumActionSupport {
    private String infoMessage;
    private List<GroupSummary> groups;

    public String execute() throws ContinuumException {
        this.groups = new ArrayList();
        Collection projectGroups = this.getContinuum().getAllProjectGroupsWithProjects();
        for (ProjectGroup projectGroup : projectGroups) {
            if (!this.isAuthorized(projectGroup.getName())) continue;
            this.getLogger().debug("GroupSummaryAction: building group " + projectGroup.getName());
            GroupSummary groupModel = new GroupSummary();
            groupModel.setId(projectGroup.getId());
            groupModel.setGroupId(projectGroup.getGroupId());
            groupModel.setName(projectGroup.getName());
            groupModel.setDescription(projectGroup.getDescription());
            if (projectGroup.getLocalRepository() != null) {
                groupModel.setRepositoryId(projectGroup.getLocalRepository().getId());
                groupModel.setRepositoryName(projectGroup.getLocalRepository().getName());
            }
            List projects = projectGroup.getProjects();
            groupModel.setNumProjects(projects.size());
            int numSuccesses = 0;
            int numFailures = 0;
            int numErrors = 0;
            for (Project project : projects) {
                if (project.getState() == 2) {
                    ++numSuccesses;
                    continue;
                }
                if (project.getState() == 3) {
                    ++numFailures;
                    continue;
                }
                if (project.getState() != 4) continue;
                ++numErrors;
            }
            groupModel.setNumSuccesses(numSuccesses);
            groupModel.setNumFailures(numFailures);
            groupModel.setNumErrors(numErrors);
            this.getLogger().debug("GroupSummaryAction: adding group to groups list " + groupModel.getName());
            this.groups.add(groupModel);
        }
        return "success";
    }

    public List<GroupSummary> getGroups() {
        return this.groups;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String infoMessage) {
        this.infoMessage = infoMessage;
    }

    private boolean isAuthorized(String projectGroupName) {
        try {
            this.checkViewProjectGroupAuthorization(projectGroupName);
            return true;
        }
        catch (AuthorizationRequiredException authzE) {
            return false;
        }
    }
}

