/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

public class BuildProjectAction
extends ContinuumActionSupport {
    private int projectId;
    private int buildDefinitionId;
    private int projectGroupId;
    private boolean fromGroupPage = false;
    private boolean fromProjectPage = false;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.projectId > 0) {
            if (this.buildDefinitionId > 0) {
                this.getContinuum().buildProjectWithBuildDefinition(this.projectId, this.buildDefinitionId);
            } else {
                this.getContinuum().buildProject(this.projectId);
            }
        } else if (this.buildDefinitionId > 0) {
            this.getContinuum().buildProjectGroupWithBuildDefinition(this.projectGroupId, this.buildDefinitionId);
        } else {
            this.getContinuum().buildProjects();
        }
        if (this.projectId > 0) {
            if (this.fromGroupPage) {
                return "to_group_page";
            }
            if (this.fromProjectPage) {
                return "to_project_page";
            }
        }
        return "success";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public int getBuildDefinition() {
        return this.buildDefinitionId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public boolean isFromGroupPage() {
        return this.fromGroupPage;
    }

    public void setFromGroupPage(boolean fromGroupPage) {
        this.fromGroupPage = fromGroupPage;
    }

    public boolean isFromProjectPage() {
        return this.fromProjectPage;
    }

    public void setFromProjectPage(boolean fromProjectPage) {
        this.fromProjectPage = fromProjectPage;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

