/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import com.opensymphony.xwork2.Validateable;
import java.util.List;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.repository.RepositoryServiceException;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddProjectGroupAction
extends ContinuumActionSupport
implements Validateable {
    private String name;
    private String groupId;
    private String description;
    private int repositoryId;
    private List<LocalRepository> repositories;

    public void prepare() throws Exception {
        super.prepare();
        this.repositories = this.getContinuum().getRepositoryService().getAllLocalRepositories();
    }

    public void validate() {
        this.clearErrorsAndMessages();
        if (this.name != null && this.name.equals("")) {
            this.addActionError(this.getText("projectGroup.error.name.required"));
        } else if (this.name != null && this.name.trim().equals("")) {
            this.addActionError(this.getText("projectGroup.error.name.cannot.be.spaces"));
        } else if (this.name != null && !this.name.equals("")) {
            for (ProjectGroup projectGroup : this.getContinuum().getAllProjectGroups()) {
                if (!this.name.equals(projectGroup.getName())) continue;
                this.addActionError(this.getText("projectGroup.error.name.already.exists"));
                break;
            }
        }
        if (this.groupId != null && this.groupId.equals("")) {
            this.addActionError(this.getText("projectGroup.error.groupId.required"));
        } else if (this.groupId != null && this.groupId.trim().equals("")) {
            this.addActionError(this.getText("projectGroup.error.groupId.cannot.be.spaces"));
        } else {
            try {
                if (this.getContinuum().getProjectGroupByGroupId(this.groupId) != null) {
                    this.addActionError(this.getText("projectGroup.error.groupId.already.exists"));
                }
            }
            catch (ContinuumException continuumException) {
                // empty catch block
            }
        }
    }

    public String execute() {
        try {
            this.checkAddProjectGroupAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        ProjectGroup projectGroup = new ProjectGroup();
        projectGroup.setName(this.name);
        projectGroup.setGroupId(this.groupId);
        projectGroup.setDescription(this.description);
        try {
            if (this.repositoryId > 0) {
                LocalRepository repository = this.getContinuum().getRepositoryService().getLocalRepository(this.repositoryId);
                projectGroup.setLocalRepository(repository);
            }
        }
        catch (RepositoryServiceException e) {
            this.getLogger().error("Error adding project group" + e.getLocalizedMessage());
            return "error";
        }
        try {
            this.getContinuum().addProjectGroup(projectGroup);
        }
        catch (ContinuumException e) {
            this.getLogger().error("Error adding project group: " + e.getLocalizedMessage());
            return "error";
        }
        return "success";
    }

    public String input() {
        try {
            this.checkAddProjectGroupAuthorization();
            return "input";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    public List<LocalRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<LocalRepository> repositories) {
        this.repositories = repositories;
    }
}

