/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.builddefinition.BuildDefinitionServiceException;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddMavenProjectAction
extends ContinuumActionSupport
implements ServletRequestAware {
    private static final long serialVersionUID = -3965565189557706469L;
    private static final int DEFINED_BY_POM_GROUP_ID = -1;
    private String pomUrl;
    private File pomFile;
    private String pom = null;
    private String scmUsername;
    private String scmPassword;
    private Collection projectGroups;
    private String projectGroupName;
    private int selectedProjectGroup = -1;
    private boolean disableGroupSelection;
    private boolean scmUseCache;
    private int projectGroupId;
    private List<BuildDefinitionTemplate> buildDefinitionTemplates;
    private int buildDefinitionTemplateId;
    private List<String> errorMessages = new ArrayList();
    private HttpServletRequest httpServletRequest;

    public String execute() throws ContinuumException, BuildDefinitionServiceException {
        try {
            this.initializeProjectGroupName();
            if (StringUtils.isEmpty((String)this.getProjectGroupName())) {
                this.checkAddProjectGroupAuthorization();
            } else {
                this.checkAddProjectToGroupAuthorization(this.getProjectGroupName());
            }
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        boolean checkProtocol = true;
        if (!StringUtils.isEmpty((String)this.pomUrl)) {
            try {
                URL url = new URL(this.pomUrl);
                if (this.pomUrl.startsWith("http") && !StringUtils.isEmpty((String)this.scmUsername)) {
                    String encoding = this.httpServletRequest.getCharacterEncoding();
                    if (StringUtils.isEmpty((String)encoding)) {
                        encoding = System.getProperty("file.encoding");
                    }
                    String encodedUsername = URLEncoder.encode(this.scmUsername, encoding);
                    String encodedPassword = URLEncoder.encode(this.scmPassword, encoding);
                    StringBuffer urlBuffer = new StringBuffer();
                    urlBuffer.append(url.getProtocol()).append("://");
                    urlBuffer.append(encodedUsername).append(':').append(encodedPassword).append('@').append(url.getHost());
                    if (url.getPort() != -1) {
                        urlBuffer.append(":").append(url.getPort());
                    }
                    urlBuffer.append(url.getPath());
                    this.pom = urlBuffer.toString();
                }
                this.pom = this.pomUrl;
            }
            catch (MalformedURLException e) {
                this.addActionError(this.getText("add.project.unknown.error"));
                return this.doDefault();
            }
            catch (UnsupportedEncodingException e) {
                this.addActionError(this.getText("add.project.unknown.error"));
                return this.doDefault();
            }
        } else if (this.pomFile != null) {
            try {
                checkProtocol = false;
                File tmpPom = File.createTempFile("continuum_tmp", "tmp");
                FileUtils.copyFile((File)this.pomFile, (File)tmpPom);
                this.pom = tmpPom.toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.addActionError(this.getText("add.project.field.required.error"));
            return this.doDefault();
        }
        ContinuumProjectBuildingResult result = this.doExecute(this.pom, this.selectedProjectGroup, checkProtocol, this.scmUseCache);
        if (result.hasErrors()) {
            for (String key : result.getErrors()) {
                String cause = (String)result.getErrorsWithCause().get(key);
                String msg = this.getText(key, new String[]{cause});
                if (key.equals("add.project.missing.scm.error")) {
                    msg = this.getResourceBundle().getString(key) + " " + cause;
                }
                if (!StringUtils.equals((String)msg, (String)key)) {
                    this.errorMessages.add(msg);
                    continue;
                }
                this.addActionError(msg);
            }
            return this.doDefault();
        }
        if (this.getSelectedProjectGroup() > 0) {
            this.setProjectGroupId(this.getSelectedProjectGroup());
            return "projectGroupSummary";
        }
        if (result.getProjectGroups() != null && !result.getProjectGroups().isEmpty()) {
            this.setProjectGroupId(((ProjectGroup)result.getProjectGroups().get(0)).getId());
            return "projectGroupSummary";
        }
        return "success";
    }

    protected abstract ContinuumProjectBuildingResult doExecute(String var1, int var2, boolean var3, boolean var4) throws ContinuumException;

    public String doDefault() throws BuildDefinitionServiceException {
        return this.input();
    }

    public String input() throws BuildDefinitionServiceException {
        try {
            this.initializeProjectGroupName();
            if (StringUtils.isEmpty((String)this.getProjectGroupName())) {
                this.checkAddProjectGroupAuthorization();
            } else {
                this.checkAddProjectToGroupAuthorization(this.getProjectGroupName());
            }
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        List allProjectGroups = this.getContinuum().getAllProjectGroups();
        this.projectGroups = new ArrayList();
        ProjectGroup defaultGroup = new ProjectGroup();
        defaultGroup.setId(-1);
        defaultGroup.setName("Defined by POM");
        this.projectGroups.add(defaultGroup);
        for (ProjectGroup pg : allProjectGroups) {
            if (!this.isAuthorizedToAddProjectToGroup(pg.getName())) continue;
            this.projectGroups.add(pg);
        }
        this.initializeProjectGroupName();
        this.setBuildDefinitionTemplates(this.getContinuum().getBuildDefinitionService().getAllBuildDefinitionTemplate());
        return "input";
    }

    private void initializeProjectGroupName() {
        if (this.disableGroupSelection && this.selectedProjectGroup != -1) {
            try {
                this.projectGroupName = this.getContinuum().getProjectGroup(this.selectedProjectGroup).getName();
            }
            catch (ContinuumException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPom() {
        return this.pom;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    public String getPomUrl() {
        return this.pomUrl;
    }

    public void setPomUrl(String pomUrl) {
        this.pomUrl = pomUrl;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public Collection getProjectGroups() {
        return this.projectGroups;
    }

    public String getProjectGroupName() {
        return this.projectGroupName;
    }

    public void setProjectGroupName(String projectGroupName) {
        this.projectGroupName = projectGroupName;
    }

    public int getSelectedProjectGroup() {
        return this.selectedProjectGroup;
    }

    public void setSelectedProjectGroup(int selectedProjectGroup) {
        this.selectedProjectGroup = selectedProjectGroup;
    }

    public boolean isDisableGroupSelection() {
        return this.disableGroupSelection;
    }

    public void setDisableGroupSelection(boolean disableGroupSelection) {
        this.disableGroupSelection = disableGroupSelection;
    }

    public boolean isScmUseCache() {
        return this.scmUseCache;
    }

    public void setScmUseCache(boolean scmUseCache) {
        this.scmUseCache = scmUseCache;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public List<BuildDefinitionTemplate> getBuildDefinitionTemplates() {
        return this.buildDefinitionTemplates;
    }

    public void setBuildDefinitionTemplates(List<BuildDefinitionTemplate> buildDefinitionTemplates) {
        this.buildDefinitionTemplates = buildDefinitionTemplates;
    }

    public int getBuildDefinitionTemplateId() {
        return this.buildDefinitionTemplateId;
    }

    public void setBuildDefinitionTemplateId(int buildDefinitionTemplateId) {
        this.buildDefinitionTemplateId = buildDefinitionTemplateId;
    }

    private boolean isAuthorizedToAddProjectToGroup(String projectGroupName) {
        try {
            this.checkAddProjectToGroupAuthorization(projectGroupName);
            return true;
        }
        catch (AuthorizationRequiredException authzE) {
            return false;
        }
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }
}

