/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action.admin;

import java.util.List;
import org.apache.continuum.builder.distributed.manager.DistributedBuildManager;
import org.apache.continuum.configuration.BuildAgentConfiguration;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAgentAction
extends ContinuumConfirmAction
implements SecureAction {
    private DistributedBuildManager distributedBuildManager;
    private List<BuildAgentConfiguration> buildAgents;
    private BuildAgentConfiguration buildAgent;
    private List<Installation> installations;
    private boolean confirmed;
    private String message;
    private String type;

    public String input() throws Exception {
        if (this.buildAgent != null && !StringUtils.isBlank((String)this.buildAgent.getUrl())) {
            List agents = this.getContinuum().getConfiguration().getBuildAgents();
            for (BuildAgentConfiguration agent : agents) {
                if (!agent.getUrl().equals(this.buildAgent.getUrl())) continue;
                this.buildAgent = agent;
                this.type = "edit";
            }
        } else {
            this.type = "new";
        }
        return "input";
    }

    public String list() throws Exception {
        String errorMessage = ServletActionContext.getRequest().getParameter("errorMessage");
        if (errorMessage != null) {
            this.addActionError(errorMessage);
        }
        this.buildAgents = this.getContinuum().getConfiguration().getBuildAgents();
        return "success";
    }

    public String view() throws Exception {
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
            if (!agent.getUrl().equals(this.buildAgent.getUrl())) continue;
            this.buildAgent = agent;
            try {
                this.installations = this.distributedBuildManager.getAvailableInstallations(this.buildAgent.getUrl());
            }
            catch (ContinuumException e) {
                this.getLogger().error("Unable to retrieve installations of build agent '" + agent.getUrl() + "'", (Throwable)e);
            }
            break;
        }
        return "success";
    }

    public String save() throws Exception {
        boolean found = false;
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        if (configuration.getBuildAgents() != null) {
            for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
                if (!this.buildAgent.getUrl().equals(agent.getUrl())) continue;
                agent.setDescription(this.buildAgent.getDescription());
                agent.setEnabled(this.buildAgent.isEnabled());
                configuration.updateBuildAgent(agent);
                found = true;
            }
        }
        if (!found) {
            configuration.addBuildAgent(this.buildAgent);
        } else if (this.type.equals("new")) {
            this.addActionError(this.getResourceBundle().getString("buildAgent.error.duplicate"));
            return "input";
        }
        this.distributedBuildManager.reload();
        return "success";
    }

    public String delete() throws Exception {
        if (!this.confirmed) {
            return "confirm";
        }
        if (this.distributedBuildManager.isBuildAgentBusy(this.buildAgent.getUrl())) {
            this.message = this.getText("buildAgent.error.delete.busy");
            return "error";
        }
        this.distributedBuildManager.removeAgentFromTaskQueueExecutor(this.buildAgent.getUrl());
        ConfigurationService configuration = this.getContinuum().getConfiguration();
        for (BuildAgentConfiguration agent : configuration.getBuildAgents()) {
            if (!this.buildAgent.getUrl().equals(agent.getUrl())) continue;
            configuration.removeBuildAgent(agent);
            return "success";
        }
        this.message = this.getText("buildAgent.error.notfound");
        return "error";
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-distributed-builds", "*");
        return bundle;
    }

    public List<BuildAgentConfiguration> getBuildAgents() {
        return this.buildAgents;
    }

    public void setBuildAgents(List<BuildAgentConfiguration> buildAgents) {
        this.buildAgents = buildAgents;
    }

    public BuildAgentConfiguration getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(BuildAgentConfiguration buildAgent) {
        this.buildAgent = buildAgent;
    }

    public List<Installation> getInstallations() {
        return this.installations;
    }

    public void setInstallations(List<Installation> installations) {
        this.installations = installations;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

