/*
 * Decompiled with CFR 0.152.
 */
package org.apache.continuum.web.action;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.continuum.model.release.ContinuumReleaseResult;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.shared.release.ReleaseResult;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseResultAction
extends ContinuumConfirmAction {
    private int projectGroupId;
    private int releaseResultId;
    private List<ContinuumReleaseResult> releaseResults;
    private List<String> selectedReleaseResults;
    private ProjectGroup projectGroup;
    private ReleaseResult result;
    private boolean confirmed;
    private String projectName;
    private String releaseGoal;

    public String list() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        this.releaseResults = this.getContinuum().getContinuumReleaseResultsByProjectGroup(this.projectGroupId);
        return "success";
    }

    public String remove() throws ContinuumException {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.confirmed) {
            if (this.selectedReleaseResults != null && !this.selectedReleaseResults.isEmpty()) {
                for (String id : this.selectedReleaseResults) {
                    int resultId = Integer.parseInt(id);
                    try {
                        this.getLogger().info("Removing ContinuumReleaseResult with id=" + resultId);
                        this.getContinuum().removeContinuumReleaseResult(resultId);
                    }
                    catch (ContinuumException e) {
                        this.getLogger().error("Error removing ContinuumReleaseResult with id=" + resultId);
                        this.addActionError(this.getText("Unable to remove ContinuumReleaseResult with id=" + resultId));
                    }
                }
            }
            return "success";
        }
        return "confirm";
    }

    public String viewResult() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        ContinuumReleaseResult releaseResult = this.getContinuum().getContinuumReleaseResult(this.releaseResultId);
        this.result = new ReleaseResult();
        this.result.setStartTime(releaseResult.getStartTime());
        this.result.setEndTime(releaseResult.getEndTime());
        this.result.setResultCode(releaseResult.getResultCode());
        this.releaseGoal = releaseResult.getReleaseGoal();
        this.projectName = releaseResult.getProject().getName();
        try {
            File releaseOutputFile = this.getContinuum().getConfiguration().getReleaseOutputFile(this.projectGroupId, "releases-" + releaseResult.getStartTime());
            if (releaseOutputFile.exists()) {
                String str = StringEscapeUtils.escapeHtml((String)FileUtils.fileRead((File)releaseOutputFile));
                this.result.appendOutput(str);
            }
        }
        catch (ConfigurationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "success";
    }

    public String getProjectGroupName() throws ContinuumException {
        return this.getProjectGroup(this.projectGroupId).getName();
    }

    public ProjectGroup getProjectGroup(int projectGroupId) throws ContinuumException {
        if (this.projectGroup == null) {
            this.projectGroup = this.getContinuum().getProjectGroup(projectGroupId);
        } else if (this.projectGroup.getId() != projectGroupId) {
            this.projectGroup = this.getContinuum().getProjectGroup(projectGroupId);
        }
        return this.projectGroup;
    }

    public ProjectGroup getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getReleaseResultId() {
        return this.releaseResultId;
    }

    public void setReleaseResultId(int releaseResultId) {
        this.releaseResultId = releaseResultId;
    }

    public List<ContinuumReleaseResult> getReleaseResults() {
        return this.releaseResults;
    }

    public void setReleaseResults(List<ContinuumReleaseResult> releaseResults) {
        this.releaseResults = releaseResults;
    }

    public List<String> getSelectedReleaseResults() {
        return this.selectedReleaseResults;
    }

    public void setSelectedReleaseResults(List<String> selectedReleaseResults) {
        this.selectedReleaseResults = selectedReleaseResults;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReleaseGoal() {
        return this.releaseGoal;
    }

    public void setReleaseGoal(String releaseGoal) {
        this.releaseGoal = releaseGoal;
    }
}

