/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.view;

import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.ActionContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.maven.continuum.web.model.ProjectSummary;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.DisplayCell;
import org.extremecomponents.table.core.TableModel;

public class BuildCell
extends DisplayCell {
    protected String getCellValue(TableModel tableModel, Column column) {
        ProjectSummary project = (ProjectSummary)tableModel.getCurrentRowBean();
        String contextPath = tableModel.getContext().getContextPath();
        int buildNumber = project.getBuildNumber();
        String result = "<div align=\"center\">";
        if (project.isInBuildingQueue()) {
            result = result + "<img src=\"" + contextPath + "/images/inqueue.gif\" alt=\"In Queue\" title=\"In Queue\" border=\"0\">";
        } else if (project.isInCheckoutQueue()) {
            result = result + "<img src=\"" + contextPath + "/images/checkingout.gif\" alt=\"Checking Out sources\" title=\"Checking Out sources\" border=\"0\">";
        } else if (project.getState() == 1 || project.getState() == 10 || project.getState() == 2 || project.getState() == 3 || project.getState() == 4) {
            if (buildNumber > 0) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("projectId", new Integer(project.getId()));
                params.put("projectName", project.getName());
                params.put("buildId", new Integer(project.getBuildInSuccessId()));
                params.put("projectGroupId", new Integer(project.getProjectGroupId()));
                PageContext pageContext = (PageContext)tableModel.getContext().getContextObject();
                HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
                HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
                String url = UrlHelper.buildUrl((String)"/buildResult.action", (HttpServletRequest)request, (HttpServletResponse)response, params);
                result = this.isAuthorized(project) ? result + "<a href=\"" + url + "\">" + buildNumber + "</a>" : result + buildNumber;
            } else {
                result = result + "&nbsp;";
            }
        } else {
            result = project.getState() == 6 ? result + "<img src=\"" + contextPath + "/images/building.gif\" alt=\"Building\" title=\"Building\" border=\"0\">" : (project.getState() == 7 ? result + "<img src=\"" + contextPath + "/images/checkingout.gif\" alt=\"Checking Out sources\" title=\"Checking Out sources\" border=\"0\">" : (project.getState() == 8 ? result + "<img src=\"" + contextPath + "/images/checkingout.gif\" alt=\"Updating sources\" title=\"Updating sources\" border=\"0\">" : result + "<img src=\"" + contextPath + "/images/inqueue.gif\" alt=\"In Queue\" title=\"In Queue\" border=\"0\">"));
        }
        return result + "</div>";
    }

    private boolean isAuthorized(ProjectSummary project) {
        ActionContext context = ActionContext.getContext();
        PlexusContainer container = (PlexusContainer)context.getApplication().get("webwork.plexus.container");
        SecuritySession securitySession = (SecuritySession)context.getSession().get("securitySession");
        try {
            SecuritySystem securitySystem = (SecuritySystem)container.lookup(SecuritySystem.ROLE);
            if (!securitySystem.isAuthorized(securitySession, (Object)"continuum-view-group", (Object)project.getProjectGroupName())) {
                return false;
            }
        }
        catch (ComponentLookupException cle) {
            return false;
        }
        catch (AuthorizationException ae) {
            return false;
        }
        return true;
    }
}

