/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.validator;

import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.ValidatorSupport;
import java.util.List;
import org.apache.maven.continuum.execution.ExecutorConfigurator;
import org.apache.maven.continuum.installation.InstallationException;
import org.apache.maven.continuum.installation.InstallationService;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class InstallationValidator
extends ValidatorSupport
implements LogEnabled {
    private String fieldName;
    private Logger logger;
    private InstallationService installationService;

    public void validate(Object object) throws ValidationException {
        String name = (String)this.getFieldValue("installation.name", object);
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        String varValue = (String)this.getFieldValue("installation.varValue", object);
        if (StringUtils.isEmpty((String)varValue)) {
            return;
        }
        String type = (String)this.getFieldValue("installation.type", object);
        ExecutorConfigurator executorConfigurator = this.installationService.getExecutorConfigurator(type);
        try {
            if (executorConfigurator != null && executorConfigurator.getVersionArgument() != null) {
                List versionInfos = this.installationService.getExecutorConfiguratorVersion(varValue, executorConfigurator, null);
            }
        }
        catch (InstallationException e) {
            String message = this.getMessage((Object)this.getMessageKey()) + e.getMessage();
            this.logger.error(message);
            this.addFieldError("installation.varValue", (Object)message);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

