/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.bean;

import java.util.Collection;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.users.User;

public class ProjectGroupUserBean {
    public static final String ROLE_ADMINISTRATOR = "Project Administrator";
    public static final String ROLE_DEVELOPER = "Project Developer";
    public static final String ROLE_USER = "Project User";
    private User user;
    private ProjectGroup projectGroup;
    private Collection roles;
    boolean isAdministrator = false;
    boolean isDeveloper = false;
    boolean isUser = false;

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public boolean isDeveloper() {
        return this.isDeveloper;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public ProjectGroup getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    public void addRole(String role) {
        this.roles.add(role);
        if (role.indexOf(ROLE_ADMINISTRATOR) != -1) {
            this.isAdministrator = true;
        }
        if (role.indexOf(ROLE_DEVELOPER) != -1) {
            this.isDeveloper = true;
        }
        if (role.indexOf(ROLE_USER) != -1) {
            this.isUser = true;
        }
    }

    public Collection getRoles() {
        return this.roles;
    }

    public void setRoles(Collection roles) {
        this.roles = roles;
        for (Role role : roles) {
            if (role.getName().indexOf(ROLE_ADMINISTRATOR) != -1) {
                this.isAdministrator = true;
            }
            if (role.getName().indexOf(ROLE_DEVELOPER) != -1) {
                this.isDeveloper = true;
            }
            if (role.getName().indexOf(ROLE_USER) == -1) continue;
            this.isUser = true;
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public String getUserFullName() {
        return this.user.getFullName();
    }

    public String getUserEmail() {
        return this.user.getEmail();
    }

    public String toString() {
        return this.user.getUsername() + ": " + this.roles + ": " + (this.isAdministrator() ? "A" : "-") + (this.isDeveloper() ? "D" : "-") + (this.isUser() ? "U" : "-");
    }
}

