/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.continuum.buildqueue.BuildProjectTask;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.scm.queue.CheckOutTask;
import org.apache.maven.continuum.web.action.admin.AbstractBuildQueueAction;
import org.apache.maven.continuum.web.exception.AuthenticationRequiredException;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskQueueExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuesAction
extends AbstractBuildQueueAction
implements SecureAction,
LogEnabled {
    private TaskQueueExecutor taskQueueExecutor;
    private BuildProjectTask currentBuildProjectTask;
    private List<BuildProjectTask> buildProjectTasks;
    private List<String> selectedBuildTaskHashCodes;
    private TaskQueueExecutor checkoutTaskQueueExecutor;
    private CheckOutTask currentCheckOutTask;
    private List<CheckOutTask> currentCheckOutTasks;
    private List<String> selectedCheckOutTaskHashCodes;
    private int buildDefinitionId;
    private int projectId;
    private int trigger;
    private String projectName;

    public String cancelCurrent() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.cancelBuild(this.projectId);
        return "success";
    }

    public String removeCheckout() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().removeProjectFromCheckoutQueue(this.projectId);
        return "success";
    }

    public String cancelCurrentCheckout() {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.cancelCheckout(this.projectId);
        return "success";
    }

    public String display() throws Exception {
        this.setCurrentBuildProjectTask((BuildProjectTask)this.taskQueueExecutor.getCurrentTask());
        this.setBuildProjectTasks(this.getContinuum().getProjectsInBuildQueue());
        this.setCurrentCheckOutTask((CheckOutTask)this.checkoutTaskQueueExecutor.getCurrentTask());
        this.setCurrentCheckOutTasks(this.getContinuum().getCheckOutTasksInQueue());
        return "success";
    }

    public String remove() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().removeFromBuildingQueue(this.projectId, this.buildDefinitionId, this.trigger, this.projectName);
        Project project = this.getContinuum().getProject(this.projectId);
        project.setState(project.getOldState());
        this.getContinuum().updateProject(project);
        return "success";
    }

    public String removeBuildEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().removeProjectsFromBuildingQueueWithHashCodes(this.listToIntArray(this.getSelectedBuildTaskHashCodes()));
        return "success";
    }

    public String removeCheckoutEntries() throws Exception {
        try {
            this.checkManageQueuesAuthorization();
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        catch (AuthenticationRequiredException e) {
            this.addActionError(e.getMessage());
            return "requires-authentication";
        }
        this.getContinuum().removeTasksFromCheckoutQueueWithHashCodes(this.listToIntArray(this.getSelectedCheckOutTaskHashCodes()));
        return "success";
    }

    private int[] listToIntArray(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return new int[0];
        }
        int[] array = new int[]{};
        for (String intString : strings) {
            array = ArrayUtils.add((int[])array, (int)Integer.parseInt(intString));
        }
        return array;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-view-queues", "*");
        return bundle;
    }

    private boolean cancelCheckout(int projectId) {
        Task task = this.getCheckoutTaskQueueExecutor().getCurrentTask();
        if (task != null) {
            if (task instanceof CheckOutTask) {
                if (((CheckOutTask)task).getProjectId() == projectId) {
                    this.getLogger().info("Cancelling checkout for project " + projectId);
                    return this.getCheckoutTaskQueueExecutor().cancelTask(task);
                }
                this.getLogger().warn("Current task is not for the given projectId (" + projectId + "): " + ((CheckOutTask)task).getProjectId() + "; not cancelling checkout");
            } else {
                this.getLogger().warn("Current task not a CheckOutTask - not cancelling checkout");
            }
        } else {
            this.getLogger().warn("No task running - not cancelling checkout");
        }
        return false;
    }

    public List<BuildProjectTask> getBuildProjectTasks() {
        return this.buildProjectTasks;
    }

    public void setBuildProjectTasks(List<BuildProjectTask> buildProjectTasks) {
        this.buildProjectTasks = buildProjectTasks;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BuildProjectTask getCurrentBuildProjectTask() {
        return this.currentBuildProjectTask;
    }

    public void setCurrentBuildProjectTask(BuildProjectTask currentBuildProjectTask) {
        this.currentBuildProjectTask = currentBuildProjectTask;
    }

    public TaskQueueExecutor getTaskQueueExecutor() {
        return this.taskQueueExecutor;
    }

    public TaskQueueExecutor getCheckoutTaskQueueExecutor() {
        return this.checkoutTaskQueueExecutor;
    }

    public void setCheckoutTaskQueueExecutor(TaskQueueExecutor checkoutTaskQueueExecutor) {
        this.checkoutTaskQueueExecutor = checkoutTaskQueueExecutor;
    }

    public CheckOutTask getCurrentCheckOutTask() {
        return this.currentCheckOutTask;
    }

    public void setCurrentCheckOutTask(CheckOutTask currentCheckOutTask) {
        this.currentCheckOutTask = currentCheckOutTask;
    }

    public List<CheckOutTask> getCurrentCheckOutTasks() {
        return this.currentCheckOutTasks;
    }

    public void setCurrentCheckOutTasks(List<CheckOutTask> currentCheckOutTasks) {
        this.currentCheckOutTasks = currentCheckOutTasks;
    }

    public List<String> getSelectedBuildTaskHashCodes() {
        return this.selectedBuildTaskHashCodes;
    }

    public void setSelectedBuildTaskHashCodes(List<String> selectedBuildTaskHashCodes) {
        this.selectedBuildTaskHashCodes = selectedBuildTaskHashCodes;
    }

    public List<String> getSelectedCheckOutTaskHashCodes() {
        return this.selectedCheckOutTaskHashCodes;
    }

    public void setSelectedCheckOutTaskHashCodes(List<String> selectedCheckOutTaskHashCodes) {
        this.selectedCheckOutTaskHashCodes = selectedCheckOutTaskHashCodes;
    }
}

