/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork.Preparable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.continuum.installation.AlreadyExistsInstallationException;
import org.apache.maven.continuum.installation.InstallationService;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationAction
extends ContinuumActionSupport
implements Preparable,
SecureAction {
    private InstallationService installationService;
    private List<Installation> installations;
    private Installation installation;
    private Map<String, String> typesLabels;
    private List<String> types;
    private boolean varNameUpdatable = false;
    private boolean automaticProfile;
    private boolean varNameDisplayable = false;
    private boolean displayTypes = true;
    private String installationType;
    private Map<String, String> installationTypes;
    private static final String TOOL_TYPE_KEY = "tool";
    private boolean automaticProfileDisplayable = true;

    public String list() throws Exception {
        this.installations = this.installationService.getAllInstallations();
        return "success";
    }

    public String edit() throws Exception {
        this.installation = this.installationService.getInstallation(this.installation.getInstallationId());
        if (this.installation != null) {
            this.configureUiFlags();
        }
        this.automaticProfileDisplayable = false;
        return "success";
    }

    public String input() throws Exception {
        if ("envvar".equalsIgnoreCase(this.getInstallationType())) {
            this.installation = new Installation();
            this.installation.setType("envvar");
            this.setDisplayTypes(false);
            this.setVarNameUpdatable(true);
            this.setVarNameDisplayable(true);
        } else {
            this.setVarNameUpdatable(false);
            this.setVarNameDisplayable(false);
        }
        return "input";
    }

    public String save() throws Exception {
        if ("envvar".equalsIgnoreCase(this.getInstallationType())) {
            this.installation.setType("envvar");
        }
        if (this.installation.getInstallationId() == 0) {
            try {
                this.installationService.add(this.installation, this.automaticProfile);
            }
            catch (AlreadyExistsInstallationException e) {
                this.addActionError(this.getResourceBundle().getString("installation.name.duplicate"));
                return "input";
            }
        } else {
            this.configureUiFlags();
            this.installationService.update(this.installation);
            return "edit";
        }
        this.configureUiFlags();
        return "success";
    }

    public String delete() throws Exception {
        Installation installationToDelete = this.installationService.getInstallation(this.installation.getInstallationId());
        this.installationService.delete(installationToDelete);
        this.installations = this.installationService.getAllInstallations();
        return "success";
    }

    public String listTypes() {
        this.installationTypes = new LinkedHashMap();
        ResourceBundle resourceBundle = this.getResourceBundle();
        this.installationTypes.put(TOOL_TYPE_KEY, resourceBundle.getString("installationTypeChoice.tool.label"));
        this.installationTypes.put("envvar", resourceBundle.getString("installationTypeChoice.envar.label"));
        return "success";
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-installations", "*");
        return bundle;
    }

    private void configureUiFlags() {
        if (!"envvar".equals(this.installation.getType())) {
            this.setDisplayTypes(true);
            this.setVarNameUpdatable(false);
        } else {
            this.setDisplayTypes(false);
            this.setVarNameUpdatable(true);
            this.setVarNameDisplayable(true);
        }
        this.setInstallationType(this.getInstallation().getType());
    }

    public List<Installation> getInstallations() {
        return this.installations;
    }

    public void setInstallations(List<Installation> installations) {
        this.installations = installations;
    }

    public Installation getInstallation() {
        return this.installation;
    }

    public void setInstallation(Installation installation) {
        this.installation = installation;
    }

    public Map<String, String> getTypesLabels() {
        if (this.typesLabels == null) {
            this.typesLabels = new LinkedHashMap();
            ResourceBundle resourceBundle = this.getResourceBundle();
            this.typesLabels.put("jdk", resourceBundle.getString("installation.jdk.type.label"));
            this.typesLabels.put("maven2", resourceBundle.getString("installation.maven2.type.label"));
            this.typesLabels.put("maven1", resourceBundle.getString("installation.maven1.type.label"));
            this.typesLabels.put("ant", resourceBundle.getString("installation.ant.type.label"));
        }
        return this.typesLabels;
    }

    public void setTypesLabels(Map<String, String> typesLabels) {
        this.typesLabels = typesLabels;
    }

    public boolean isVarNameUpdatable() {
        return this.varNameUpdatable;
    }

    public void setVarNameUpdatable(boolean varNameUpdatable) {
        this.varNameUpdatable = varNameUpdatable;
    }

    public List<String> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList(5);
            this.types.add("jdk");
            this.types.add("maven2");
            this.types.add("maven1");
            this.types.add("ant");
        }
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean isAutomaticProfile() {
        return this.automaticProfile;
    }

    public void setAutomaticProfile(boolean automaticProfile) {
        this.automaticProfile = automaticProfile;
    }

    public Map<String, String> getInstallationTypes() {
        return this.installationTypes;
    }

    public void setInstallationTypes(Map<String, String> installationTypes) {
        this.installationTypes = installationTypes;
    }

    public boolean isVarNameDisplayable() {
        return this.varNameDisplayable;
    }

    public void setVarNameDisplayable(boolean varNameDisplayable) {
        this.varNameDisplayable = varNameDisplayable;
    }

    public boolean isDisplayTypes() {
        return this.displayTypes;
    }

    public void setDisplayTypes(boolean displayTypes) {
        this.displayTypes = displayTypes;
    }

    public String getInstallationType() {
        return this.installationType;
    }

    public void setInstallationType(String installationType) {
        this.installationType = installationType;
    }

    public boolean isAutomaticProfileDisplayable() {
        return this.automaticProfileDisplayable;
    }

    public void setAutomaticProfileDisplayable(boolean automaticProfileDisplayable) {
        this.automaticProfileDisplayable = automaticProfileDisplayable;
    }
}

