/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork.ModelDriven;
import java.io.IOException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.continuum.execution.maven.m2.MavenBuilderHelper;
import org.apache.maven.continuum.execution.maven.m2.SettingsConfigurationException;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.app.company.CompanyPomHandler;
import org.apache.maven.shared.app.configuration.CompanyPom;
import org.apache.maven.shared.app.configuration.Configuration;
import org.apache.maven.shared.app.configuration.MavenAppConfiguration;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;

public class EditPomAction
extends ContinuumActionSupport
implements ModelDriven,
SecureAction {
    private MavenAppConfiguration appConfiguration;
    private Configuration configuration;
    private CompanyPomHandler companyPomHandler;
    private Model companyModel;
    private MavenBuilderHelper helper;

    public String execute() throws IOException, ArtifactInstallationException, SettingsConfigurationException {
        String[] logo = (String[])this.companyModel.getProperties().get("organization.logo");
        if (logo != null) {
            this.companyModel.getProperties().put("organization.logo", logo[0]);
        }
        this.companyPomHandler.save(this.companyModel, this.helper.getLocalRepository());
        return "success";
    }

    public String input() {
        return "input";
    }

    public Object getModel() {
        return this.companyModel;
    }

    public void prepare() throws ProjectBuildingException, ArtifactMetadataRetrievalException, SettingsConfigurationException {
        this.configuration = this.appConfiguration.getConfiguration();
        CompanyPom companyPom = this.configuration.getCompanyPom();
        this.companyModel = this.companyPomHandler.getCompanyPomModel(companyPom, this.helper.getLocalRepository());
        if (this.companyModel == null) {
            this.companyModel = new Model();
            this.companyModel.setModelVersion("4.0.0");
            this.companyModel.setPackaging("pom");
            if (companyPom != null) {
                this.companyModel.setGroupId(companyPom.getGroupId());
                this.companyModel.setArtifactId(companyPom.getArtifactId());
            }
        }
    }

    public Model getCompanyModel() {
        return this.companyModel;
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-configuration", "*");
        return bundle;
    }
}

