/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import com.opensymphony.xwork.Preparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.builddefinition.BuildDefinitionServiceException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.web.action.AbstractBuildDefinitionAction;
import org.apache.maven.continuum.web.model.BuildDefinitionSummary;
import org.codehaus.plexus.redback.xwork.interceptor.SecureAction;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionBundle;
import org.codehaus.plexus.redback.xwork.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDefinitionTemplateAction
extends AbstractBuildDefinitionAction
implements SecureAction,
Preparable {
    private List<BuildDefinitionTemplate> templates;
    private BuildDefinitionTemplate buildDefinitionTemplate;
    private List<String> buildDefinitionTypes;
    private List<BuildDefinitionSummary> buildDefinitionSummaries;
    private BuildDefinition buildDefinition;
    private Collection<Schedule> schedules;
    private List<Profile> profiles;
    private List<String> selectedBuildDefinitionIds;
    private List<BuildDefinition> buildDefinitions;

    public void prepare() throws Exception {
        super.prepare();
        this.buildDefinitionTypes = new LinkedList();
        this.buildDefinitionTypes.add("maven2");
        this.buildDefinitionTypes.add("maven-1");
        this.buildDefinitionTypes.add("ant");
        this.buildDefinitionTypes.add("shell");
        this.setSchedules(this.getContinuum().getSchedules());
        this.setProfiles(this.getContinuum().getProfileService().getAllProfiles());
        this.setBuildDefinitions(this.getContinuum().getBuildDefinitionService().getAllTemplates());
    }

    public String input() throws Exception {
        return "input";
    }

    public String summary() throws Exception {
        this.templates = this.getContinuum().getBuildDefinitionService().getAllBuildDefinitionTemplate();
        List buildDefinitions = this.getContinuum().getBuildDefinitionService().getAllTemplates();
        this.buildDefinitionSummaries = this.generateBuildDefinitionSummaries(buildDefinitions);
        return "success";
    }

    public String edit() throws Exception {
        this.buildDefinitionTemplate = this.getContinuum().getBuildDefinitionService().getBuildDefinitionTemplate(this.buildDefinitionTemplate.getId());
        this.setBuildDefinitions(this.getContinuum().getBuildDefinitionService().getAllTemplates());
        this.selectedBuildDefinitionIds = new ArrayList();
        if (this.buildDefinitionTemplate.getBuildDefinitions() != null) {
            Iterator iterator = this.buildDefinitionTemplate.getBuildDefinitions().iterator();
            while (iterator.hasNext()) {
                this.selectedBuildDefinitionIds.add(Integer.toString(((BuildDefinition)iterator.next()).getId()));
            }
        }
        ArrayList<BuildDefinition> nonUsedBuildDefinitions = new ArrayList<BuildDefinition>();
        for (BuildDefinition buildDefinition : this.getBuildDefinitions()) {
            if (this.getSelectedBuildDefinitionIds().contains(Integer.toString(buildDefinition.getId()))) continue;
            nonUsedBuildDefinitions.add(buildDefinition);
        }
        this.setBuildDefinitions(nonUsedBuildDefinitions);
        return "success";
    }

    public String save() throws Exception {
        List selectedBuildDefinitions = this.getBuildDefinitionsFromSelectedBuildDefinitions();
        if (this.buildDefinitionTemplate.getId() > 0) {
            this.buildDefinitionTemplate.setBuildDefinitions(selectedBuildDefinitions);
            this.getContinuum().getBuildDefinitionService().updateBuildDefinitionTemplate(this.buildDefinitionTemplate);
        } else {
            this.buildDefinitionTemplate.setBuildDefinitions(selectedBuildDefinitions);
            this.buildDefinitionTemplate = this.getContinuum().getBuildDefinitionService().addBuildDefinitionTemplate(this.buildDefinitionTemplate);
        }
        return "success";
    }

    public String delete() throws BuildDefinitionServiceException {
        this.buildDefinitionTemplate = this.getContinuum().getBuildDefinitionService().getBuildDefinitionTemplate(this.buildDefinitionTemplate.getId());
        this.getContinuum().getBuildDefinitionService().removeBuildDefinitionTemplate(this.buildDefinitionTemplate);
        return "success";
    }

    private List<BuildDefinition> getBuildDefinitionsFromSelectedBuildDefinitions() throws ContinuumException {
        if (this.selectedBuildDefinitionIds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BuildDefinition> selectedBuildDefinitions = new ArrayList<BuildDefinition>();
        for (String selectedBuildDefinitionId : this.selectedBuildDefinitionIds) {
            BuildDefinition buildDefinition = this.getContinuum().getBuildDefinition(Integer.parseInt(selectedBuildDefinitionId));
            selectedBuildDefinitions.add(buildDefinition);
        }
        return selectedBuildDefinitions;
    }

    public String inputBuildDefinition() {
        return "input";
    }

    public String editBuildDefinition() throws Exception {
        this.buildDefinition = this.getContinuum().getBuildDefinitionService().getBuildDefinition(this.buildDefinition.getId());
        return "success";
    }

    public String saveBuildDefinition() throws Exception {
        if (this.buildDefinition.getProfile() != null) {
            Profile profile = this.getContinuum().getProfileService().getProfile(this.buildDefinition.getProfile().getId());
            if (profile != null) {
                this.buildDefinition.setProfile(profile);
            } else {
                this.buildDefinition.setProfile(null);
            }
        }
        if (this.buildDefinition.getSchedule() != null && this.buildDefinition.getSchedule().getId() > 0) {
            this.buildDefinition.setSchedule(this.getContinuum().getSchedule(this.buildDefinition.getSchedule().getId()));
        }
        if (this.buildDefinition.getId() > 0) {
            this.getContinuum().getBuildDefinitionService().updateBuildDefinition(this.buildDefinition);
        } else {
            this.buildDefinition = this.getContinuum().getBuildDefinitionService().addBuildDefinition(this.buildDefinition);
        }
        return "success";
    }

    public String deleteBuildDefinition() throws BuildDefinitionServiceException {
        this.buildDefinition = this.getContinuum().getBuildDefinitionService().getBuildDefinition(this.buildDefinition.getId());
        this.getContinuum().getBuildDefinitionService().removeBuildDefinition(this.buildDefinition);
        return "success";
    }

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("continuum-manage-build-templates", "*");
        return bundle;
    }

    public BuildDefinitionTemplate getBuildDefinitionTemplate() {
        if (this.buildDefinitionTemplate == null) {
            this.buildDefinitionTemplate = new BuildDefinitionTemplate();
        }
        return this.buildDefinitionTemplate;
    }

    public void setBuildDefinitionTemplate(BuildDefinitionTemplate buildDefinitionTemplate) {
        this.buildDefinitionTemplate = buildDefinitionTemplate;
    }

    public List<String> getBuildDefinitionTypes() {
        return this.buildDefinitionTypes;
    }

    public void setBuildDefinitionTypes(List<String> buildDefinitionTypes) {
        this.buildDefinitionTypes = buildDefinitionTypes;
    }

    public List<BuildDefinitionTemplate> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<BuildDefinitionTemplate> templates) {
        this.templates = templates;
    }

    public List<BuildDefinitionSummary> getBuildDefinitionSummaries() {
        return this.buildDefinitionSummaries;
    }

    public void setBuildDefinitionSummaries(List<BuildDefinitionSummary> buildDefinitionSummaries) {
        this.buildDefinitionSummaries = buildDefinitionSummaries;
    }

    public BuildDefinition getBuildDefinition() {
        if (this.buildDefinition == null) {
            this.buildDefinition = new BuildDefinition();
        }
        return this.buildDefinition;
    }

    public void setBuildDefinition(BuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public void setSchedules(Collection<Schedule> schedules) {
        this.schedules = schedules;
    }

    public Collection<Schedule> getSchedules() {
        return this.schedules;
    }

    public List<BuildDefinition> getBuildDefinitions() {
        return this.buildDefinitions;
    }

    public void setBuildDefinitions(List<BuildDefinition> buildDefinitions) {
        this.buildDefinitions = buildDefinitions;
    }

    public List<String> getSelectedBuildDefinitionIds() {
        return this.selectedBuildDefinitionIds == null ? Collections.EMPTY_LIST : this.selectedBuildDefinitionIds;
    }

    public void setSelectedBuildDefinitionIds(List<String> selectedBuildDefinitionIds) {
        this.selectedBuildDefinitionIds = selectedBuildDefinitionIds;
    }
}

