/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action.admin;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.buildqueue.BuildProjectTask;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.execution.TaskQueueExecutor;

public abstract class AbstractBuildQueueAction
extends ContinuumActionSupport
implements LogEnabled {
    private TaskQueueExecutor taskQueueExecutor;

    protected boolean cancelBuild(int projectId) throws ContinuumException {
        Task task = this.getTaskQueueExecutor().getCurrentTask();
        if (task != null) {
            if (task instanceof BuildProjectTask) {
                if (((BuildProjectTask)task).getProjectId() == projectId) {
                    this.getLogger().info("Cancelling task for project " + projectId);
                    return this.getTaskQueueExecutor().cancelTask(task);
                }
                this.getLogger().warn("Current task is not for the given projectId (" + projectId + "): " + ((BuildProjectTask)task).getProjectId() + "; not cancelling");
            } else {
                this.getLogger().warn("Current task not a BuildProjectTask - not cancelling");
            }
        } else {
            this.getLogger().warn("No task running - not cancelling");
        }
        return false;
    }

    protected int getCurrentProjectIdBuilding() throws ContinuumException {
        Task task = this.getTaskQueueExecutor().getCurrentTask();
        if (task != null && task instanceof BuildProjectTask) {
            return ((BuildProjectTask)task).getProjectId();
        }
        return -1;
    }

    public TaskQueueExecutor getTaskQueueExecutor() {
        return this.taskQueueExecutor;
    }
}

