/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.util.UrlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.util.WorkingCopyContentGenerator;
import org.codehaus.plexus.util.StringUtils;

public class WorkingCopyAction
extends ContinuumActionSupport {
    private WorkingCopyContentGenerator generator;
    private Project project;
    private int projectId;
    private String userDirectory;
    private String currentFile;
    private String currentFileContent;
    private String output;
    private String projectName;
    private File downloadFile;
    private String mimeType = "application/octet-stream";
    private static String FILE_SEPARATOR = System.getProperty("file.separator");
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if ("release.properties".equals(this.currentFile)) {
            throw new ContinuumException("release.properties is not accessible.");
        }
        List files = this.getContinuum().getFiles(this.projectId, this.userDirectory);
        this.project = this.getContinuum().getProject(this.projectId);
        this.projectName = this.project.getName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", new Integer(this.projectId));
        params.put("projectName", this.projectName);
        String baseUrl = UrlHelper.buildUrl((String)"/workingCopy.action", (HttpServletRequest)ServletActionContext.getRequest(), (HttpServletResponse)ServletActionContext.getResponse(), params);
        String imagesBaseUrl = UrlHelper.buildUrl((String)"/images/", (HttpServletRequest)ServletActionContext.getRequest(), (HttpServletResponse)ServletActionContext.getResponse(), params);
        imagesBaseUrl = imagesBaseUrl.substring(0, imagesBaseUrl.indexOf("/images/") + "/images/".length());
        this.output = this.generator.generate(files, baseUrl, imagesBaseUrl, this.getContinuum().getWorkingDirectory(this.projectId));
        if (this.currentFile != null && !this.currentFile.equals("")) {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            mimeTypesMap.addMimeTypes("application/java-archive jar war ear");
            mimeTypesMap.addMimeTypes("application/java-class class");
            mimeTypesMap.addMimeTypes("image/png png");
            String dir = FILE_SEPARATOR.equals(this.userDirectory) ? this.userDirectory : FILE_SEPARATOR + this.userDirectory + FILE_SEPARATOR;
            this.downloadFile = new File(this.getContinuum().getWorkingDirectory(this.projectId) + dir + this.currentFile);
            this.mimeType = mimeTypesMap.getContentType(this.downloadFile);
            if (this.mimeType.indexOf("image") >= 0 || this.mimeType.indexOf("java-archive") >= 0 || this.mimeType.indexOf("java-class") >= 0 || this.downloadFile.length() > 100000L) {
                return "stream";
            }
            this.currentFileContent = this.getContinuum().getFileContent(this.projectId, this.userDirectory, this.currentFile);
        } else {
            this.currentFileContent = "";
        }
        return "success";
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUserDirectory() {
        return this.userDirectory;
    }

    public void setUserDirectory(String userDirectory) {
        this.userDirectory = userDirectory;
    }

    public void setFile(String currentFile) {
        this.currentFile = currentFile;
    }

    public String getFile() {
        return this.currentFile;
    }

    public String getOutput() {
        return this.output;
    }

    public String getFileContent() {
        return this.currentFileContent;
    }

    public InputStream getInputStream() throws ContinuumException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.downloadFile);
        }
        catch (FileNotFoundException fne) {
            throw new ContinuumException("Error accessing file.", (Throwable)fne);
        }
        return fis;
    }

    public String getFileLength() {
        return Long.toString(this.downloadFile.length());
    }

    public String getDownloadFilename() {
        return this.downloadFile.getName();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

