/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.StringUtils;

public class ReleaseProjectGoalAction
extends ContinuumActionSupport {
    private int projectId;
    private int projectGroupId;
    private String projectName;
    private String preparedReleaseName;
    private String preparedReleaseId;
    private String projectGroupName = "";

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        Project project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        String releaseId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        Map preparedReleases = releaseManager.getPreparedReleases();
        if (preparedReleases.containsKey(releaseId)) {
            ReleaseDescriptor descriptor = (ReleaseDescriptor)preparedReleases.get(releaseId);
            this.preparedReleaseName = descriptor.getReleaseVersions().get(releaseId).toString();
            this.preparedReleaseId = releaseId;
        }
        this.projectName = project.getName();
        return "success";
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPreparedReleaseName() {
        return this.preparedReleaseName;
    }

    public void setPreparedReleaseName(String preparedReleaseName) {
        this.preparedReleaseName = preparedReleaseName;
    }

    public String getPreparedReleaseId() {
        return this.preparedReleaseId;
    }

    public void setPreparedReleaseId(String preparedReleaseId) {
        this.preparedReleaseId = preparedReleaseId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

