/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.StringUtils;

public class ReleaseProjectAction
extends ContinuumActionSupport {
    private int projectId;
    private String projectName;
    private String preparedReleaseName;
    private String preparedReleaseId;
    private String goal;
    private String scmUrl;
    private Project project;
    private List releaseList;
    private String projectGroupName = "";

    public String promptReleaseGoal() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        String releaseId = ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId());
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        Map preparedReleases = releaseManager.getPreparedReleases();
        if (preparedReleases.containsKey(releaseId)) {
            ReleaseDescriptor descriptor = (ReleaseDescriptor)preparedReleases.get(releaseId);
            this.preparedReleaseName = descriptor.getReleaseVersions().get(releaseId).toString();
            this.preparedReleaseId = releaseId;
        }
        this.projectName = this.project.getName();
        return "success";
    }

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if ("prepare".equals(this.goal)) {
            return "prepareRelease";
        }
        if ("perform".equals(this.goal)) {
            if ("".equals(this.preparedReleaseId)) {
                return "performReleaseFromScm";
            }
            return "performRelease";
        }
        return "prompt";
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getPreparedReleaseName() {
        return this.preparedReleaseName;
    }

    public void setPreparedReleaseName(String preparedReleaseName) {
        this.preparedReleaseName = preparedReleaseName;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public List getReleaseList() {
        return this.releaseList;
    }

    public void setReleaseList(List releaseList) {
        this.releaseList = releaseList;
    }

    public String getPreparedReleaseId() {
        return this.preparedReleaseId;
    }

    public void setPreparedReleaseId(String preparedReleaseId) {
        this.preparedReleaseId = preparedReleaseId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

