/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.io.File;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.release.ContinuumReleaseManager;
import org.apache.maven.continuum.release.ContinuumReleaseManagerListener;
import org.apache.maven.continuum.release.DefaultReleaseManagerListener;
import org.apache.maven.continuum.web.action.ContinuumActionSupport;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;

public class ReleasePerformAction
extends ContinuumActionSupport {
    private int projectId;
    private String releaseId;
    private String scmUrl;
    private String scmUsername;
    private String scmPassword;
    private String scmTag;
    private String scmTagBase;
    private String goals;
    private boolean useReleaseProfile;
    private ContinuumReleaseManagerListener listener;
    private ReleaseResult result;
    private String projectGroupName = "";

    public String inputFromScm() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.populateFromProject();
        this.releaseId = "";
        return "success";
    }

    public String input() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        return "success";
    }

    public String execute() throws Exception {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.listener = new DefaultReleaseManagerListener();
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        Project project = this.getContinuum().getProject(this.projectId);
        File performDirectory = new File(this.getContinuum().getConfiguration().getWorkingDirectory(), "releases-" + System.currentTimeMillis());
        performDirectory.mkdirs();
        LocalRepository repository = project.getProjectGroup().getLocalRepository();
        releaseManager.perform(this.releaseId, performDirectory, this.goals, this.useReleaseProfile, this.listener, repository);
        return "success";
    }

    public String executeFromScm() throws Exception {
        ContinuumReleaseManager releaseManager = this.getContinuum().getReleaseManager();
        ReleaseDescriptor descriptor = new ReleaseDescriptor();
        descriptor.setScmSourceUrl(this.scmUrl);
        descriptor.setScmUsername(this.scmUsername);
        descriptor.setScmPassword(this.scmPassword);
        descriptor.setScmReleaseLabel(this.scmTag);
        descriptor.setScmTagBase(this.scmTagBase);
        do {
            this.releaseId = String.valueOf(System.currentTimeMillis());
        } while (releaseManager.getPreparedReleases().containsKey(this.releaseId));
        releaseManager.getPreparedReleases().put(this.releaseId, descriptor);
        return this.execute();
    }

    private void populateFromProject() throws Exception {
        Project project = this.getContinuum().getProjectWithAllDetails(this.projectId);
        this.scmUrl = project.getScmUrl();
        this.scmUsername = project.getScmUsername();
        this.scmPassword = project.getScmPassword();
        this.scmTagBase = this.scmUrl.startsWith("scm:svn:") ? new SvnScmProviderRepository(this.scmUrl, this.scmUsername, this.scmPassword).getTagBase() : "";
        this.releaseId = "";
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public String getGoals() {
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public boolean isUseReleaseProfile() {
        return this.useReleaseProfile;
    }

    public void setUseReleaseProfile(boolean useReleaseProfile) {
        this.useReleaseProfile = useReleaseProfile;
    }

    public ContinuumReleaseManagerListener getListener() {
        return this.listener;
    }

    public void setListener(ContinuumReleaseManagerListener listener) {
        this.listener = listener;
    }

    public ReleaseResult getResult() {
        return this.result;
    }

    public void setResult(ReleaseResult result) {
        this.result = result;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }
}

