/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.web.action.admin.AbstractBuildQueueAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelBuildAction
extends AbstractBuildQueueAction {
    private int projectId;
    private int projectGroupId;
    private List<String> selectedProjects;
    private String projectGroupName = "";

    public String execute() throws ContinuumException {
        try {
            this.checkBuildProjectInGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.cancelBuild(this.projectId);
        return "success";
    }

    public String cancelBuilds() throws ContinuumException {
        if (this.getSelectedProjects() == null || this.getSelectedProjects().isEmpty()) {
            return "success";
        }
        int[] projectsId = new int[this.getSelectedProjects().size()];
        for (String selectedProjectId : this.getSelectedProjects()) {
            int projectId = Integer.parseInt(selectedProjectId);
            projectsId = ArrayUtils.add((int[])projectsId, (int)projectId);
        }
        this.getContinuum().removeProjectsFromBuildingQueue(projectsId);
        int index = ArrayUtils.indexOf((int[])projectsId, (int)this.getCurrentProjectIdBuilding());
        if (index > 0) {
            this.cancelBuild(projectsId[index]);
        }
        return "success";
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public List<String> getSelectedProjects() {
        return this.selectedProjects;
    }

    public void setSelectedProjects(List<String> selectedProjects) {
        this.selectedProjects = selectedProjects;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }
}

