/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.web.action.AbstractBuildAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.util.StateGenerator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class BuildResultAction
extends AbstractBuildAction {
    private Project project;
    private BuildResult buildResult;
    private int buildId;
    private List changeSet;
    private boolean hasSurefireResults;
    private String buildOutput;
    private String state;
    private String projectGroupName = "";

    public String execute() throws ContinuumException, ConfigurationException, IOException {
        try {
            this.checkViewProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        this.project = this.getContinuum().getProject(this.getProjectId());
        this.buildResult = this.getContinuum().getBuildResult(this.getBuildId());
        File surefireReportsDirectory = this.getContinuum().getConfiguration().getTestReportsDirectory(this.buildId, this.getProjectId());
        File[] files = surefireReportsDirectory.listFiles();
        this.hasSurefireResults = files == null ? false : files.length > 0;
        this.changeSet = this.getContinuum().getChangesSinceLastSuccess(this.getProjectId(), this.getBuildId());
        this.buildOutput = this.getBuildOutputText();
        this.state = StateGenerator.generate((int)this.buildResult.getState(), (String)ServletActionContext.getRequest().getContextPath());
        this.setCanDelete(this.canRemoveBuildResult(this.buildResult));
        return "success";
    }

    public String remove() throws ContinuumException {
        try {
            this.checkModifyProjectGroupAuthorization(this.getProjectGroupName());
        }
        catch (AuthorizationRequiredException e) {
            return "requires-authorization";
        }
        if (this.isConfirmed()) {
            this.getContinuum().removeBuildResult(this.buildId);
            return "success";
        }
        return "confirm";
    }

    public String buildLogAsText() throws ConfigurationException, IOException {
        this.buildOutput = this.getBuildOutputText();
        return "success";
    }

    public InputStream getBuildOutputInputStream() throws ConfigurationException, IOException {
        String outputText = this.getBuildOutputText();
        return outputText == null ? null : IOUtils.toInputStream((String)outputText);
    }

    private String getBuildOutputText() throws ConfigurationException, IOException {
        File buildOutputFile = this.getContinuum().getConfiguration().getBuildOutputFile(this.getBuildId(), this.getProjectId());
        if (buildOutputFile.exists()) {
            return StringEscapeUtils.escapeHtml((String)FileUtils.fileRead((File)buildOutputFile));
        }
        return null;
    }

    public int getBuildId() {
        return this.buildId;
    }

    public void setBuildId(int buildId) {
        this.buildId = buildId;
    }

    public Project getProject() {
        return this.project;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public List getChangesSinceLastSuccess() {
        return this.changeSet;
    }

    public boolean isHasSurefireResults() {
        return this.hasSurefireResults;
    }

    public void setHasSurefireResults(boolean hasSurefireResults) {
        this.hasSurefireResults = hasSurefireResults;
    }

    public String getBuildOutput() {
        return this.buildOutput;
    }

    public String getState() {
        return this.state;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (StringUtils.isEmpty((String)this.projectGroupName)) {
            this.projectGroupName = this.getContinuum().getProjectGroupByProjectId(this.getProjectId()).getName();
        }
        return this.projectGroupName;
    }
}

