/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.builddefinition.BuildDefinitionService;
import org.apache.maven.continuum.builddefinition.BuildDefinitionServiceException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.profile.ProfileException;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.apache.maven.continuum.web.action.ContinuumConfirmAction;
import org.apache.maven.continuum.web.exception.AuthorizationRequiredException;
import org.apache.maven.continuum.web.exception.ContinuumActionException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDefinitionAction
extends ContinuumConfirmAction {
    private int buildDefinitionId;
    private int projectId;
    private int projectGroupId;
    private int scheduleId;
    private boolean defaultBuildDefinition;
    private boolean confirmed = false;
    private String executor;
    private String goals;
    private String arguments;
    private String buildFile;
    private boolean buildFresh;
    private Map schedules;
    private List profiles;
    private boolean groupBuildDefinition = false;
    private String projectGroupName = "";
    private int profileId;
    private String description;
    private List<String> buildDefinitionTypes;
    private String buildDefinitionType;
    private boolean alwaysBuild;
    private BuildDefinitionService buildDefinitionService;

    public void prepare() throws Exception {
        super.prepare();
        if (this.schedules == null) {
            this.schedules = new HashMap();
            Collection allSchedules = this.getContinuum().getSchedules();
            for (Schedule schedule : allSchedules) {
                this.schedules.put(new Integer(schedule.getId()), schedule.getName());
            }
        }
        if (this.profiles == null) {
            this.profiles = this.getContinuum().getProfileService().getAllProfiles();
        }
        this.buildDefinitionTypes = new ArrayList();
        this.buildDefinitionTypes.add("ant");
        this.buildDefinitionTypes.add("maven-1");
        this.buildDefinitionTypes.add("maven2");
        this.buildDefinitionTypes.add("shell");
    }

    public String input() throws ContinuumException, ContinuumStoreException, BuildDefinitionServiceException {
        try {
            if (this.executor == null) {
                if (this.projectId != 0) {
                    this.executor = this.getContinuum().getProject(this.projectId).getExecutorId();
                } else {
                    List projects = this.getContinuum().getProjectGroupWithProjects(this.projectGroupId).getProjects();
                    if (projects.size() > 0) {
                        Project project = (Project)projects.get(0);
                        this.executor = project.getExecutorId();
                    }
                }
            }
            if (this.buildDefinitionId != 0) {
                if (this.projectId != 0) {
                    this.checkModifyProjectBuildDefinitionAuthorization(this.getProjectGroupName());
                } else {
                    this.checkModifyGroupBuildDefinitionAuthorization(this.getProjectGroupName());
                }
                BuildDefinition buildDefinition = this.getContinuum().getBuildDefinition(this.buildDefinitionId);
                this.goals = buildDefinition.getGoals();
                this.arguments = buildDefinition.getArguments();
                this.buildFile = buildDefinition.getBuildFile();
                this.buildFresh = buildDefinition.isBuildFresh();
                this.scheduleId = buildDefinition.getSchedule().getId();
                this.defaultBuildDefinition = buildDefinition.isDefaultForProject();
                Profile profile = buildDefinition.getProfile();
                if (profile != null) {
                    this.profileId = profile.getId();
                }
                this.description = buildDefinition.getDescription();
                this.buildDefinitionType = buildDefinition.getType();
                this.alwaysBuild = buildDefinition.isAlwaysBuild();
            } else {
                String preDefinedBuildFile = "";
                if (this.projectId != 0) {
                    this.checkAddProjectBuildDefinitionAuthorization(this.getProjectGroupName());
                    BuildDefinition bd = this.getContinuum().getDefaultBuildDefinition(this.projectId);
                    if (bd != null) {
                        preDefinedBuildFile = bd.getBuildFile();
                    }
                } else {
                    this.checkAddGroupBuildDefinitionAuthorization(this.getProjectGroupName());
                    List bds = this.getContinuum().getBuildDefinitionsForProjectGroup(this.projectGroupId);
                    if (bds != null && !bds.isEmpty()) {
                        preDefinedBuildFile = ((BuildDefinition)bds.get(0)).getBuildFile();
                    }
                }
                if (StringUtils.isEmpty((String)preDefinedBuildFile)) {
                    if ("maven2".equals(this.executor)) {
                        this.buildFile = ((BuildDefinition)this.buildDefinitionService.getDefaultMavenTwoBuildDefinitionTemplate().getBuildDefinitions().get(0)).getBuildFile();
                        this.buildDefinitionType = "maven2";
                    } else if ("maven-1".equals(this.executor)) {
                        this.buildFile = ((BuildDefinition)this.buildDefinitionService.getDefaultMavenOneBuildDefinitionTemplate().getBuildDefinitions().get(0)).getBuildFile();
                        this.buildDefinitionType = "maven-1";
                    } else if ("ant".equals(this.executor)) {
                        this.buildFile = ((BuildDefinition)this.buildDefinitionService.getDefaultAntBuildDefinitionTemplate().getBuildDefinitions().get(0)).getBuildFile();
                        this.buildDefinitionType = "ant";
                    } else {
                        this.buildDefinitionType = "shell";
                    }
                } else {
                    this.buildFile = preDefinedBuildFile;
                }
            }
            if (StringUtils.isEmpty((String)this.buildDefinitionType)) {
                this.buildDefinitionType = "maven2".equals(this.executor) ? "maven2" : ("maven-1".equals(this.executor) ? "maven-1" : ("ant".equals(this.executor) ? "ant" : "shell"));
            }
        }
        catch (AuthorizationRequiredException authzE) {
            return "requires-authorization";
        }
        return "success";
    }

    public String saveBuildDefinition() throws ContinuumException, ProfileException {
        if (this.projectId != 0 && !this.groupBuildDefinition) {
            return this.saveToProject();
        }
        return this.saveToGroup();
    }

    public String saveToProject() throws ContinuumException, ProfileException {
        try {
            if (this.buildDefinitionId == 0) {
                this.checkAddProjectBuildDefinitionAuthorization(this.getProjectGroupName());
                this.getContinuum().addBuildDefinitionToProject(this.projectId, this.getBuildDefinitionFromInput());
            } else {
                this.checkModifyProjectBuildDefinitionAuthorization(this.getProjectGroupName());
                this.getContinuum().updateBuildDefinitionForProject(this.projectId, this.getBuildDefinitionFromInput());
            }
        }
        catch (ContinuumActionException cae) {
            this.addActionError(cae.getMessage());
            return "input";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        return "success";
    }

    public String saveToGroup() throws ContinuumException, ProfileException {
        try {
            BuildDefinition newBuildDef = this.getBuildDefinitionFromInput();
            if (this.getContinuum().getBuildDefinitionsForProjectGroup(this.projectGroupId).size() == 0) {
                newBuildDef.setDefaultForProject(true);
            }
            if (this.buildDefinitionId == 0) {
                this.checkAddGroupBuildDefinitionAuthorization(this.getProjectGroupName());
                this.getContinuum().addBuildDefinitionToProjectGroup(this.projectGroupId, newBuildDef);
            } else {
                this.checkModifyGroupBuildDefinitionAuthorization(this.getProjectGroupName());
                this.getContinuum().updateBuildDefinitionForProjectGroup(this.projectGroupId, newBuildDef);
            }
        }
        catch (ContinuumActionException cae) {
            this.addActionError(cae.getMessage());
            return "input";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
        if (this.projectId != 0) {
            return "success";
        }
        return "success_group";
    }

    public String removeFromProject() throws ContinuumException {
        try {
            this.checkRemoveProjectBuildDefinitionAuthorization(this.getProjectGroupName());
            if (this.confirmed) {
                this.getContinuum().removeBuildDefinitionFromProject(this.projectId, this.buildDefinitionId);
                return "success";
            }
            BuildDefinition buildDefinition = this.getContinuum().getBuildDefinition(this.buildDefinitionId);
            this.description = buildDefinition.getDescription();
            this.goals = buildDefinition.getGoals();
            return "confirm";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
    }

    public String removeFromProjectGroup() throws ContinuumException {
        try {
            this.checkRemoveGroupBuildDefinitionAuthorization(this.getProjectGroupName());
            if (this.confirmed) {
                this.getContinuum().removeBuildDefinitionFromProjectGroup(this.projectGroupId, this.buildDefinitionId);
                return "success";
            }
            BuildDefinition buildDefinition = this.getContinuum().getBuildDefinition(this.buildDefinitionId);
            this.description = buildDefinition.getDescription();
            this.goals = buildDefinition.getGoals();
            return "confirm";
        }
        catch (AuthorizationRequiredException authzE) {
            this.addActionError(authzE.getMessage());
            return "requires-authorization";
        }
    }

    private BuildDefinition getBuildDefinitionFromInput() throws ContinuumActionException, ProfileException {
        Profile profile;
        Schedule schedule;
        try {
            schedule = this.getContinuum().getSchedule(this.scheduleId);
        }
        catch (ContinuumException e) {
            this.addActionError("unable to get schedule");
            throw new ContinuumActionException("unable to get schedule");
        }
        BuildDefinition buildDefinition = new BuildDefinition();
        if (this.buildDefinitionId != 0) {
            buildDefinition.setId(this.buildDefinitionId);
        }
        buildDefinition.setGoals(this.goals);
        buildDefinition.setArguments(this.arguments);
        buildDefinition.setBuildFile(this.buildFile);
        buildDefinition.setBuildFresh(this.buildFresh);
        buildDefinition.setDefaultForProject(this.defaultBuildDefinition);
        buildDefinition.setSchedule(schedule);
        if (this.profileId != -1 && (profile = this.getContinuum().getProfileService().getProfile(this.profileId)) != null) {
            buildDefinition.setProfile(profile);
        }
        buildDefinition.setDescription(this.description);
        buildDefinition.setType(this.buildDefinitionType);
        buildDefinition.setAlwaysBuild(this.alwaysBuild);
        return buildDefinition;
    }

    public int getBuildDefinitionId() {
        return this.buildDefinitionId;
    }

    public void setBuildDefinitionId(int buildDefinitionId) {
        this.buildDefinitionId = buildDefinitionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getProjectGroupId() {
        return this.projectGroupId;
    }

    public void setProjectGroupId(int projectGroupId) {
        this.projectGroupId = projectGroupId;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public boolean isDefaultBuildDefinition() {
        return this.defaultBuildDefinition;
    }

    public void setDefaultBuildDefinition(boolean defaultBuildDefinition) {
        this.defaultBuildDefinition = defaultBuildDefinition;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public String getGoals() {
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public boolean isBuildFresh() {
        return this.buildFresh;
    }

    public void setBuildFresh(boolean buildFresh) {
        this.buildFresh = buildFresh;
    }

    public Map getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Map schedules) {
        this.schedules = schedules;
    }

    public List getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List profiles) {
        this.profiles = profiles;
    }

    public boolean isGroupBuildDefinition() {
        return this.groupBuildDefinition;
    }

    public void setGroupBuildDefinition(boolean groupBuildDefinition) {
        this.groupBuildDefinition = groupBuildDefinition;
    }

    public String getProjectGroupName() throws ContinuumException {
        if (this.projectGroupName == null || "".equals(this.projectGroupName)) {
            this.projectGroupName = this.projectGroupId != 0 ? this.getContinuum().getProjectGroup(this.projectGroupId).getName() : this.getContinuum().getProjectGroupByProjectId(this.projectId).getName();
        }
        return this.projectGroupName;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int profileId) {
        this.profileId = profileId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBuildDefinitionType() {
        return this.buildDefinitionType;
    }

    public void setBuildDefinitionType(String buildDefinitionType) {
        this.buildDefinitionType = buildDefinitionType;
    }

    public List<String> getBuildDefinitionTypes() {
        return this.buildDefinitionTypes;
    }

    public boolean isAlwaysBuild() {
        return this.alwaysBuild;
    }

    public void setAlwaysBuild(boolean alwaysBuild) {
        this.alwaysBuild = alwaysBuild;
    }
}

